%--------------------------------------------------------------------------
% File     : NUM016=InfPrmEx-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : There exist infinitely many primes
% Version  : [Chang, 1970] axioms : Incomplete.
% English  : 

% Refs     : Luckham D. (1968), Some Tree-paring Strategies for Theorem 
%            Proving, Michie D. (Ed), Machine Intelligence 3, 95-112.
%          : Chang C.L. (1970), The Unit Proof and the Input Proof 
%            in Theorem Proving, Communications of the ACM 17(4), 698-707.
%          : Chang C.L., Lee R.C.T. (1973), Symbolic Logic and Mechanical 
%            Theorem Proving, Academic Press, New York.
% Source   : [Chang, 1970]
% Names    : Example 8a [Luckham, 1968]
%          : Chang-Lee-9 [Chang, 1970]

% Status   : 
% Syntax   : Number of clauses           :    8 (   3 non-Horn)(   2 unit)
%            Number of literals          :   15 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    3 (   1 constant)
%            Number of variables         :   10 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(nothing_is_less_than_itself,axiom,
    [--less(X,X)]).

input_clause(numbers_are_different,axiom,
    [--less(X,Y),
     --less(Y,X)]).

input_clause(a_prime_is_less_than_the_next_one,axiom,
    [++less(X,factorial_plus_one(X))]).

input_clause(divisor_is_smaller,axiom,
    [--divides(X,factorial_plus_one(Y)),
     ++less(Y,X)]).

input_clause(division_by_prime_divisor,axiom,
    [++prime(X),
     ++divides(prime_divisor(X),X)]).

input_clause(prime_divsiors,axiom,
    [++prime(X),
     ++prime(prime_divisor(X))]).

input_clause(smaller_prime_divisors,axiom,
    [++prime(X),
     ++less(prime_divisor(X),X)]).

input_clause(prove_there_is_another_prime,theorem,
    [--prime(X),
     --less(a,X),
     ++less(factorial_plus_one(a),X)]).
%--------------------------------------------------------------------------
