%--------------------------------------------------------------------------
% File     : NUM016=InfPrmEx-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : There exist infinitely many primes
% Version  : [Lawrence & Starkey, 1974] axioms.
% English  : 

% Refs     : Luckham D. (1968), Some Tree-paring Strategies for Theorem 
%            Proving, Michie D. (Ed), Machine Intelligence 3, 95-112.
%          : Chang C.L. (1970), The Unit Proof and the Input Proof 
%            in Theorm Proving, Communications of the ACM 17(4), 698-707.
%          : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : Example 8b [Luckham, 1968]
%          : ls17 [Lawrence & Starkey, 1974]
%          : Problem 17 [Lawrence & Starkey, 1974]
%          : ls17 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   12 (   3 non-Horn)(   4 unit)
%            Number of literals          :   22 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    3 (   1 constant)
%            Number of variables         :   16 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : These axioms are the same as in [Luckham, 1968]
%--------------------------------------------------------------------------
input_clause(nothing_is_less_than_itself,axiom,
    [--less(X,X)]).

input_clause(numbers_are_different,axiom,
    [--less(X,Y),
     --less(Y,X)]).

input_clause(everything_divides_itself,axiom,
    [++divides(X,X)]).

input_clause(transitivity_of_divides,axiom,
    [--divides(X,Y),
     --divides(Y,Z),
     ++divides(X,Z)]).

input_clause(small_divides_large,axiom,
    [--divides(X,Y),
     --less(Y,X)]).

input_clause(a_prime_is_less_than_the_next_one,axiom,
    [++less(X,factorial_plus_one(X))]).

input_clause(divisor_is_smaller,axiom,
    [--divides(X,factorial_plus_one(Y)),
     ++less(Y,X)]).

input_clause(division_by_prime_divisor,axiom,
    [++prime(X),
     ++divides(prime_divisor(X),X)]).

input_clause(prime_divsiors,axiom,
    [++prime(X),
     ++prime(prime_divisor(X))]).

input_clause(smaller_prime_divisors,axiom,
    [++prime(X),
     ++less(prime_divisor(X),X)]).

input_clause(a_is_prime,hypothesis,
    [++prime(a)]).

input_clause(prove_there_is_another_prime,theorem,
    [--prime(X),
     --less(a,X),
     ++less(factorial_plus_one(a),X)]).
%--------------------------------------------------------------------------
