%--------------------------------------------------------------------------
% File     : NUM015=PrmDivEx-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Any number greater than 1 has a prime divisor
% Version  : [Chang, 1970] axioms : Incomplete.
% English  : 

% Refs     : Luckham D. (1968), Some Tree-paring Strategies for Theorem 
%            Proving, Michie D. (Ed), Machine Intelligence 3, 95-112.
%          : Loveland D.W. (1969), Theorem-provers Combining Model 
%            Elimination and Resolution, Meltzer B, Michie D. (Eds), 
%            Machine Intelligence 4, 73-86.
%          : Chang C.L. (1970), The Unit Proof and the Input Proof 
%            in Theorem Proving, Communications of the ACM 17(4), 698-707.
%          : Chang C.L., Lee R.C.T. (1973), Symbolic Logic and Mechanical 
%            Theorem Proving, Academic Press, New York.
%          : Fleisig S., Loveland D.W., Smiley A.K. and Yarmush D.L. 
%            (1974), An Implementation of the Model Elimination Proof 
%            Procedure, Journal of the ACM 21(1), 124-139.
% Source   : [Chang, 1970]
% Names    : Example 7 [Luckham, 1968]
%          : Example 2 [Loveland, 1969]
%          : Chang-Lee-8 [Chang, 1970]
%          : Example 3 [Fleisig, et al., 1974]

% Status   : 
% Syntax   : Number of clauses           :    9 (   3 non-Horn)(   2 unit)
%            Number of literals          :   19 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    4 (   2 constant)
%            Number of variables         :   10 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(divide_self,axiom,
    [++divides(X,X)]).

input_clause(transitive_divide,axiom,
    [--divides(X,Y),
     --divides(Y,Z),
     ++divides(X,Z)]).

input_clause(prime,axiom,
    [++prime(X),
     ++divides(divisor(X),X)]).

input_clause(divisor1,axiom,
    [++prime(X),
     ++less(1,divisor(X))]).

input_clause(divisor2,axiom,
    [++prime(X),
     ++less(divisor(X),X)]).

input_clause(factor1,axiom,
    [--less(1,X),
     --less(X,a),
     ++prime(factor_of(X))]).

input_clause(factor2,axiom,
    [--less(1,X),
     --less(X,a),
     ++divides(factor_of(X),X)]).

input_clause(a_is_greater_than_1,hypothesis,
    [++less(1,a)]).

input_clause(prove_a_has_prime_divisor,theorem,
    [--prime(X),
     --divides(X,a)]).
%--------------------------------------------------------------------------
