%--------------------------------------------------------------------------
% File     : NUM014=ValIsPrm-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : If a is a prime and a = b^2/c^2 then a divides b
% Version  : [Chang, 1970] axioms : Incomplete.
% English  : 

% Refs     : Luckham D. (1968), Some Tree-paring Strategies for Theorem 
%            Proving, Michie D. (Ed), Machine Intelligence 3, 95-112.
%          : Chang C.L. (1970), The Unit Proof and the Input Proof 
%            in Theorm Proving, Communications of the ACM 17(4), 698-707.
%          : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
%          : Fleisig S., Loveland D.W., Smiley A.K. and Yarmush D.L. 
%            (1974), An Implementation of the Model Elimination Proof 
%            Procedure, Journal of the ACM 21(1), 124-139.
% Source   : [Chang, 1970]
% Names    : Example 6 [Luckham, 1968]
%          : Chang-Lee-7 [Chang, 1970]
%          : Example 2 [Fleisig, et al., 1974]

% Status   : 
% Syntax   : Number of clauses           :    7 (   1 non-Horn)(   4 unit)
%            Number of literals          :   13 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   11 (   1 singleton)
%            Maximal clause size         :    5
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
input_clause(square,axiom,
    [++product(X,X,square(X))]).

input_clause(commutativity,axiom,
    [--product(X,Y,Z),
     ++product(Y,X,Z)]).

input_clause(divides,axiom,
    [--product(X,Y,Z),
     ++divides(X,Z)]).

input_clause(remainder,axiom,
    [--prime(X),
     --product(Y,Z,U),
     --divides(X,U),
     ++divides(X,Y),
     ++divides(X,Z)]).

input_clause(a_is_prime,hypothesis,
    [++prime(a)]).

input_clause(a_equals_b_squared_by_c_squared,hypothesis,
    [++product(a,square(c),square(b))]).

input_clause(prove_a_divides_b,theorem,
    [--divides(a,b)]).
%--------------------------------------------------------------------------
