%--------------------------------------------------------------------------
% File     : NUM013=Peano6-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Peano axiom 5
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Problem 242-244 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  408 (  59 non-Horn)(  14 unit)
%            Number of literals          : 1050 ( 409 equality)
%            Number of predicate symbols :   20 (   0 propositional)
%            Number of function symbols  :   93 (  13 constant)
%            Number of variables         : 1093 (  32 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%----Include the axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.ax').
%----Include the equality axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.eq').
%----Include the axioms for number theory from Godel's set axioms 
include('Axioms/NUM003-0.ax').
%----Include the equality axioms for number theory from Godel's set 
%----axioms 
include('Axioms/NUM003-0.eq').
%--------------------------------------------------------------------------
input_clause(zero_in_set,hypothesis,
    [++member(empty_set,f78)]).

input_clause(successor_in_set,hypothesis,
    [--member(Xk,f78),
     ++member(successor(Xk),f78)]).

input_clause(prove_set_is_in_naturals,theorem,
    [--subset(natural_numbers,f78)]).
%--------------------------------------------------------------------------
