%--------------------------------------------------------------------------
% File     : NUM012=Peano5-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Peano axiom 4
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Problem 238-241 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  409 (  59 non-Horn)(  16 unit)
%            Number of literals          : 1050 ( 411 equality)
%            Number of predicate symbols :   20 (   0 propositional)
%            Number of function symbols  :   94 (  14 constant)
%            Number of variables         : 1092 (  32 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%----Include the axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.ax').
%----Include the equality axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.eq').
%----Include the axioms for number theory from Godel's set axioms 
include('Axioms/NUM003-0.ax').
%----Include the equality axioms for number theory from Godel's set 
%----axioms 
include('Axioms/NUM003-0.eq').
%--------------------------------------------------------------------------
input_clause(a_natural_number,hypothesis,
    [++member(f76,natural_numbers)]).

input_clause(another_natural_number,hypothesis,
    [++member(f77,natural_numbers)]).

input_clause(successors_are_equal,hypothesis,
    [++equal(successor(f76),successor(f77))]).

input_clause(prove_well_definedness_of_successor,theorem,
    [--equal(f76,f77)]).
%--------------------------------------------------------------------------
