%--------------------------------------------------------------------------
% File     : NUM011=Peano4-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Peano axiom 3
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Problem 236-237 [Boyer, et al., 1986]

% Status   : 
% Syntax   : Number of clauses           :  407 (  59 non-Horn)(  14 unit)
%            Number of literals          : 1048 ( 410 equality)
%            Number of predicate symbols :   20 (   0 propositional)
%            Number of function symbols  :   93 (  13 constant)
%            Number of variables         : 1092 (  32 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%----Include the axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.ax').
%----Include the equality axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.eq').
%----Include the axioms for number theory from Godel's set axioms 
include('Axioms/NUM003-0.ax').
%----Include the equality axioms for number theory from Godel's set 
%----axioms 
include('Axioms/NUM003-0.eq').
%--------------------------------------------------------------------------
input_clause(a_natural_number,hypothesis,
    [++member(f75,natural_numbers)]).

input_clause(prove_zero_is_first,theorem,
    [++equal(empty_set,successor(f75))]).
%--------------------------------------------------------------------------
