%--------------------------------------------------------------------------
% File     : NUM007=LCM-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Least Common Multiple
% Version  : [Wang & Bledsoe, 1987] axioms : Reduced > Complete.
% English  : If LCM(a,b) is the least common multiple of two positive 
%            integers a, b, then LCM(a,b) = a*b/GCD(a,b).

% Refs     : Wang T-C. (1985), Designing Examples for Semantically Guided 
%            Hierarchical Deduction, In Joshi A. (Ed.), Proceedings of the 
%            9th International Joint Conference on Artificial Intelligence 
%            (Los Angeles, CA, 1985), International Joint Conferences 
%            on Artificial Intelligence, Inc., Los Altos, CA, 1201-1207.
%          : Wang T-C., Bledsoe W.W. (1987), Hierarchical Deduction, 
%            Journal of Automated Deduction 3(1), 35-77.
% Source   : [Wang & Bledsoe, 1987]
% Names    : lcm [Wang, 1985]
%          : lcm [Wang & Bledsoe, 1987]

% Status   : 
% Syntax   : Number of clauses           :   46 (   4 non-Horn)(   9 unit)
%            Number of literals          :  110 (  37 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :  138 (   4 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    3

% Comments : The axiom number 4. in [Wang & Bledsoe, 1987] is omitted 
%            because it can be derived from axioms 2 and 3.
%          : Wang & Bledsoe's version uses a built in commutative 
%            unification system. I've added the axioms for this.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(h_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(h(A,C,D),h(B,C,D))]).

input_clause(h_substitutivity2,axiom,
    [--equal(E,F),
     ++equal(h(G,E,H),h(G,F,H))]).

input_clause(h_substitutivity3,axiom,
    [--equal(I,J),
     ++equal(h(K,L,I),h(K,L,J))]).

input_clause(k_substitutivity1,axiom,
    [--equal(S,T),
     ++equal(k(S,U,V),k(T,U,V))]).

input_clause(k_substitutivity2,axiom,
    [--equal(W,X),
     ++equal(k(Y,W,Z),k(Y,X,Z))]).

input_clause(k_substitutivity3,axiom,
    [--equal(A1,B1),
     ++equal(k(C1,D1,A1),k(C1,D1,B1))]).

input_clause(multiply_substitutivity1,axiom,
    [--equal(E1,F1),
     ++equal(multiply(E1,G1),multiply(F1,G1))]).

input_clause(multiply_substitutivity2,axiom,
    [--equal(H1,I1),
     ++equal(multiply(J1,H1),multiply(J1,I1))]).

input_clause(quotient_substitutivity1,axiom,
    [--equal(K1,L1),
     ++equal(quotient(K1,M1),quotient(L1,M1))]).

input_clause(quotient_substitutivity2,axiom,
    [--equal(N1,O1),
     ++equal(quotient(P1,N1),quotient(P1,O1))]).

input_clause(divides_substitutivity1,axiom,
    [--equal(Q1,R1),
     --divides(Q1,S1),
     ++divides(R1,S1)]).

input_clause(divides_substitutivity2,axiom,
    [--equal(T1,U1),
     --divides(V1,T1),
     ++divides(V1,U1)]).

input_clause(gcd_substitutivity1,axiom,
    [--equal(W1,X1),
     --gcd(W1,Y1,Z1),
     ++gcd(X1,Y1,Z1)]).

input_clause(gcd_substitutivity2,axiom,
    [--equal(A2,B2),
     --gcd(C2,A2,D2),
     ++gcd(C2,B2,D2)]).

input_clause(gcd_substitutivity3,axiom,
    [--equal(E2,F2),
     --gcd(G2,H2,E2),
     ++gcd(G2,H2,F2)]).

input_clause(lcm_substitutivity1,axiom,
    [--equal(I2,J2),
     --lcm(I2,K2,L2),
     ++lcm(J2,K2,L2)]).

input_clause(lcm_substitutivity2,axiom,
    [--equal(M2,N2),
     --lcm(O2,M2,P2),
     ++lcm(O2,N2,P2)]).

input_clause(lcm_substitutivity3,axiom,
    [--equal(Q2,R2),
     --lcm(S2,T2,Q2),
     ++lcm(S2,T2,R2)]).

input_clause(reflexivity_of_divides,axiom,
    [++divides(X,X)]).

input_clause(transitivity_of_divides,axiom,
    [++divides(X,Z),
     --divides(X,Y),
     --divides(Y,Z)]).

input_clause(operand_divides_product,axiom,
    [++divides(X,multiply(X,Y))]).

input_clause(divides_and_multiply,axiom,
    [++divides(multiply(X,Y),multiply(X,Z)),
     --divides(Y,Z)]).

input_clause(one_divides_everything,axiom,
    [++divides(quotient(X,X),Y)]).

input_clause(divides_quotient_multiply1,axiom,
    [++divides(X,multiply(Y,Z)),
     --divides(Y,X),
     --divides(quotient(X,Y),Z)]).

input_clause(divides_quotient_multiply2,axiom,
    [++divides(X,quotient(Y,Z)),
     --divides(Z,Y),
     --divides(multiply(X,Z),Y)]).

input_clause(divides_quotient_multiply3,axiom,
    [++divides(quotient(X,Y),Z),
     --divides(Y,X),
     --divides(X,multiply(Y,Z))]).

input_clause(gcd_divides1,axiom,
    [++divides(U,Y),
     --gcd(X,Y,U)]).

input_clause(gcd_divides2,axiom,
    [++divides(U,X),
     --gcd(X,Y,U)]).

input_clause(gcd1,axiom,
    [++divides(V,U),
     --divides(V,X),
     --divides(V,Y),
     --gcd(X,Y,U)]).

input_clause(gcd2,axiom,
    [++gcd(X,Y,U),
     --divides(U,X),
     --divides(U,Y),
     ++divides(h(Y,X,U),X)]).

input_clause(gcd3,axiom,
    [++gcd(X,Y,U),
     --divides(U,X),
     --divides(U,Y),
     ++divides(h(Y,X,U),Y)]).

input_clause(gcd4,axiom,
    [++gcd(X,Y,U),
     --divides(U,X),
     --divides(U,Y),
     --divides(h(Y,X,U),U)]).

input_clause(property_of_gcd,axiom,
    [++gcd(multiply(Z,X),multiply(Z,Y),multiply(Z,U)),
     --gcd(X,Y,U)]).

input_clause(lcm1,axiom,
    [++lcm(X,Y,U),
     --divides(X,U),
     --divides(Y,U),
     ++divides(X,k(Y,X,U))]).

input_clause(lcm2,axiom,
    [++lcm(X,Y,U),
     --divides(X,U),
     --divides(Y,U),
     ++divides(Y,k(Y,X,U))]).

input_clause(lcm3,axiom,
    [++lcm(X,Y,U),
     --divides(X,U),
     --divides(Y,U),
     --divides(U,k(Y,X,U))]).

input_clause(commutativity_of_k,axiom,
    [++equal(k(X,Y,Z),k(Y,X,Z))]).

input_clause(commutativity_of_h,axiom,
    [++equal(h(X,Y,Z),h(Y,X,Z))]).

input_clause(commutativity_of_multiply,axiom,
    [++equal(multiply(X,Y),multiply(Y,X))]).

input_clause(commutativity_of_lcm,axiom,
    [--lcm(X,Y,Z),
     ++lcm(Y,X,Z)]).

input_clause(commutativity_of_gcd,axiom,
    [--gcd(X,Y,Z),
     ++gcd(Y,X,Z)]).

input_clause(c_is_gcd_of_a_and_b,hypothesis,
    [++gcd(a,b,c)]).

input_clause(prove_lcm,axiom,
    [--lcm(a,b,quotient(multiply(a,b),c))]).
%--------------------------------------------------------------------------
