%--------------------------------------------------------------------------
% File     : NUM006=Goldbach-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Goldbach conjecture
% Version  : [Boyer, et al., 1986] axioms.
% English  : 

% Refs     : Boyer R., Lusk E., McCune W., Overbeek R., Stickel M. and 
%            Wos L. (1986), Set Theory in First-Order Logic: Clauses for 
%            Godel's Axioms,  Journal of Automated Reasoning 2(3), 
%            287-327.
% Source   : [Boyer, et al., 1986]
% Names    : Problem 246-248 [Boyer, et al., 1986]

% Status   : open
% Syntax   : Number of clauses           :  408 (  59 non-Horn)(  14 unit)
%            Number of literals          : 1051 ( 410 equality)
%            Number of predicate symbols :   20 (   0 propositional)
%            Number of function symbols  :   93 (  13 constant)
%            Number of variables         : 1094 (  32 singleton)
%            Maximal clause size         :    8
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include the axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Godel's set axioms 
include('Axioms/SET003-0.ax').
%----Include the equality axioms for Godel's set axioms 
include('Axioms/SET003-0.eq').
%----Include the axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.ax').
%----Include the equality axioms for algebra from Godel's set axioms 
include('Axioms/ALG001-0.eq').
%----Include the axioms for number theory from Godel's set axioms 
include('Axioms/NUM003-0.ax').
%----Include the equality axioms for number theory from Godel's set 
%----axioms 
include('Axioms/NUM003-0.eq').
%--------------------------------------------------------------------------
input_clause(an_even_number,hypothesis,
    [++member(f79,even_numbers)]).

input_clause(its_not_0_or_2,hypothesis,
    [--member(f79,non_ordered_pair(empty_set,successor(
successor(empty_set))))]).

input_clause(prove_its_not_the_sum_of_two_primes,theorem,
    [--member(X,prime_numbers),
     --member(Y,prime_numbers),
     --equal(apply_to_two_arguments(plus,X,Y),f79)]).
%--------------------------------------------------------------------------
