%--------------------------------------------------------------------------
% File     : NUM005=GCD-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : Greatest Common Divisor
% Version  : [Wang & Bledsoe, 1987] axioms : Reduced > Complete.
% English  : If GCD(a,b) is the greatest common divisor of two positive 
%            a, b, then for any positive integer d, GCD(a*d,b*d) 
%            = GCD(a,b)*d.

% Refs     : Wang T-C. (1985), Designing Examples for Semantically Guided 
%            Hierarchical Deduction, In Joshi A. (Ed.), Proceedings of the 
%            9th International Joint Conference on Artificial Intelligence 
%            (Los Angeles, CA, 1985), International Joint Conferences 
%            on Artificial Intelligence, Inc., Los Altos, CA, 1201-1207.
%          : Wang T-C., Bledsoe W.W. (1987), Hierarchical Deduction, 
%            Journal of Automated Deduction 3(1), 35-77.
% Source   : [Wang & Bledsoe, 1987]
% Names    : gcd [Wang, 1985]
%          : gcd [Wang & Bledsoe, 1987]

% Status   : 
% Syntax   : Number of clauses           :   40 (   2 non-Horn)(  11 unit)
%            Number of literals          :   88 (  32 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :  110 (   6 singleton)
%            Maximal clause size         :    4
%            Maximal term depth          :    2

% Comments : The axiom number 4. in [Wang & Bledsoe, 1987] is omitted 
%            because it can be derived from axioms 2 and 3.
%          : Wang & Bledsoe's version uses a built in commutative 
%            unification system. I've added the axioms for this.
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(h_substitutivity1,axiom,
    [--equal(J,K),
     ++equal(h(J,L,M),h(K,L,M))]).

input_clause(h_substitutivity2,axiom,
    [--equal(N,O),
     ++equal(h(P,N,Q),h(P,O,Q))]).

input_clause(h_substitutivity3,axiom,
    [--equal(R,S),
     ++equal(h(T,U,R),h(T,U,S))]).

input_clause(k_substitutivity1,axiom,
    [--equal(V,W),
     ++equal(k(V,X),k(W,X))]).

input_clause(k_substitutivity2,axiom,
    [--equal(Y,Z),
     ++equal(k(A1,Y),k(A1,Z))]).

input_clause(multiply_substitutivity1,axiom,
    [--equal(B1,C1),
     ++equal(multiply(B1,D1),multiply(C1,D1))]).

input_clause(multiply_substitutivity2,axiom,
    [--equal(E1,F1),
     ++equal(multiply(G1,E1),multiply(G1,F1))]).

input_clause(quotient_substitutivity1,axiom,
    [--equal(H1,I1),
     ++equal(quotient(H1,J1),quotient(I1,J1))]).

input_clause(quotient_substitutivity2,axiom,
    [--equal(K1,L1),
     ++equal(quotient(M1,K1),quotient(M1,L1))]).

input_clause(divides_substitutivity1,axiom,
    [--equal(N1,O1),
     --divides(N1,P1),
     ++divides(O1,P1)]).

input_clause(divides_substitutivity2,axiom,
    [--equal(Q1,R1),
     --divides(S1,Q1),
     ++divides(S1,R1)]).

input_clause(gcd_substitutivity1,axiom,
    [--equal(T1,U1),
     --gcd(T1,V1,W1),
     ++gcd(U1,V1,W1)]).

input_clause(gcd_substitutivity2,axiom,
    [--equal(X1,Y1),
     --gcd(Z1,X1,A2),
     ++gcd(Z1,Y1,A2)]).

input_clause(gcd_substitutivity3,axiom,
    [--equal(B2,C2),
     --gcd(D2,E2,B2),
     ++gcd(D2,E2,C2)]).

input_clause(reflexivity_of_divides,axiom,
    [++divides(X,X)]).

input_clause(transitivity_of_divides,axiom,
    [++divides(X,Z),
     --divides(X,Y),
     --divides(Y,Z)]).

input_clause(operand_divides_product,axiom,
    [++divides(X,multiply(X,Y))]).

input_clause(divides_and_multiply,axiom,
    [++divides(multiply(X,Y),multiply(X,Z)),
     --divides(Y,Z)]).

input_clause(one_divides_everything,axiom,
    [++divides(quotient(X,X),Y)]).

input_clause(divides_quotient_multiply1,axiom,
    [++divides(X,multiply(Y,Z)),
     --divides(Y,X),
     --divides(quotient(X,Y),Z)]).

input_clause(divides_quotient_multiply2,axiom,
    [++divides(X,quotient(Y,Z)),
     --divides(Z,Y),
     --divides(multiply(X,Z),Y)]).

input_clause(divides_quotient_multiply3,axiom,
    [++divides(quotient(X,Y),Z),
     --divides(Y,X),
     --divides(X,multiply(Y,Z))]).

input_clause(gcd_divides1,axiom,
    [++divides(U,Y),
     --gcd(X,Y,U)]).

input_clause(gcd_divides2,axiom,
    [++divides(U,X),
     --gcd(X,Y,U)]).

input_clause(divides_k1,axiom,
    [++divides(k(Y,X),X)]).

input_clause(divides_k2,axiom,
    [++divides(k(Y,X),Y)]).

input_clause(divides_k3,axiom,
    [++divides(V,k(Y,X)),
     --divides(V,X),
     --divides(V,Y)]).

input_clause(gcd1,axiom,
    [++divides(V,U),
     --divides(V,X),
     --divides(V,Y),
     --gcd(X,Y,U)]).

input_clause(gcd2,axiom,
    [++gcd(X,Y,U),
     --divides(U,X),
     --divides(U,Y),
     ++divides(h(Y,X,U),X)]).

input_clause(gcd3,axiom,
    [++gcd(X,Y,U),
     --divides(U,X),
     --divides(U,Y),
     ++divides(h(Y,X,U),Y)]).

input_clause(gcd4,axiom,
    [++gcd(X,Y,U),
     --divides(U,X),
     --divides(U,Y),
     --divides(h(Y,X,U),U)]).

input_clause(commutativity_of_h,axiom,
    [++equal(h(X,Y,Z),h(Y,X,Z))]).

input_clause(commutativity_of_k,axiom,
    [++equal(k(X,Y),k(Y,X))]).

input_clause(commutativity_of_multiply,axiom,
    [++equal(multiply(X,Y),multiply(Y,X))]).

input_clause(commutativity_of_gcd,axiom,
    [--gcd(X,Y,Z),
     ++gcd(Y,X,Z)]).

input_clause(e_is_gcd_of_a_and_b,hypothesis,
    [++gcd(a,b,e)]).

input_clause(prove_gcd,theorem,
    [--gcd(multiply(a,c),multiply(b,c),multiply(e,c))]).
%--------------------------------------------------------------------------
