%--------------------------------------------------------------------------
% File     : NUM004=SumDiff3-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Number Theory
% Problem  : (A + B) - C = A + (B - C)
% Version  : [Lawrence & Starkey, 1974] (equality) axioms.
% English  : 

% Refs     : Chang C.L. (1970), The Unit Proof and the Input Proof 
%            in Theorm Proving, Communications of the ACM 17(4), 698-707.
%          : Lawrence J.D., Starkey J.D. (1974), Experimental tests 
%            of resolution based theorem-proving strategies, Technical 
%            Report, Computer Science Department, Washington State 
%            University, Pullman, Washington.
% Source   : [Chang, 1970]
% Names    : Chang-Lee-10d [Chang, 1970]
%          : Problem 29 [Lawrence & Starkey, 1974]

% Status   : 
% Syntax   : Number of clauses           :   13 (   0 non-Horn)(   8 unit)
%            Number of literals          :   23 (  23 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   35 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : The axioms are OK, even though symmetry and some substitution 
%            axioms are missing.
%--------------------------------------------------------------------------
%----Include additive algebra axioms 
include('Axioms/NUM002-0.ax').
%--------------------------------------------------------------------------
input_clause(prove_equation,theorem,
    [--equal(subtract(add(a,b),c),add(a,subtract(b,c)))]).
%--------------------------------------------------------------------------
