%--------------------------------------------------------------------------
% File     : MSC008=LatSq-2.002 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : The inconstructability of a Graeco-Latin Square
% Version  : Theorem formulation : Corrected; A 2x2 square.
% English  : The constructibility of Graeco-Latin squares of order 4t+2. 
%            This is impossible for t=0,1, but possible for all other 
%            cases.

% Refs     : Robinson J.A. (1963), Theorem Proving on the Computer, Journal 
%            of the ACM 10(2), ACM Press, New York, NY, 163-174.
% Source   : [SPRFN]
% Names    : LATINSQ [SPRFN]

% Status   : 
% Syntax   : Number of clauses           :   16 (   7 non-Horn)(   2 unit)
%            Number of literals          :   40 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    2 (   2 constant)
%            Number of variables         :   45 (   0 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    1

% Comments : This uses an erroneous form of the theorem.
%--------------------------------------------------------------------------
input_clause(p1_is_not_p2,axiom,
    [--eq(p1,p2)]).

input_clause(reflexivity,axiom,
    [++eq(A,A)]).

input_clause(symmetry,axiom,
    [--eq(A,B),
     ++eq(B,A)]).

input_clause(latin_element_is_unique,axiom,
    [--latin(A,B,C),
     --latin(A,B,D),
     ++eq(D,C)]).

input_clause(latin_column_is_unique,axiom,
    [--latin(A,B,C),
     --latin(A,D,C),
     ++eq(D,B)]).

input_clause(latin_row_is_unique,axiom,
    [--latin(A,B,C),
     --latin(D,B,C),
     ++eq(D,A)]).

input_clause(greek_element_is_unique,axiom,
    [--greek(A,B,C),
     --greek(A,B,D),
     ++eq(D,C)]).

input_clause(greek_column_is_unique,axiom,
    [--greek(A,B,C),
     --greek(A,D,C),
     ++eq(D,B)]).

input_clause(greek_row_is_unique,axiom,
    [--greek(A,B,C),
     --greek(D,B,C),
     ++eq(D,A)]).

input_clause(latin_cell_element,axiom,
    [++latin(E,F,p1),
     ++latin(E,F,p2)]).

input_clause(latin_column_required,axiom,
    [++latin(G,p1,H),
     ++latin(G,p2,H)]).

input_clause(latin_row_required,axiom,
    [++latin(p1,I,J),
     ++latin(p2,I,J)]).

input_clause(greek_cell_element,axiom,
    [++greek(K,L,p1),
     ++greek(K,L,p2)]).

input_clause(greek_column_required,axiom,
    [++greek(M,p1,N),
     ++greek(M,p2,N)]).

input_clause(greek_row_required,axiom,
    [++greek(p1,O,P),
     ++greek(p2,O,P)]).

input_clause(no_two_same,theorem,
    [--greek(A,B,C),
     --latin(A,B,D),
     --greek(E,F,C),
     --latin(E,F,D),
     ++eq(F,B),
     ++eq(E,A)]).

%----This is the fixed version. Original is wrong I think 
%input_clause(no_two_same1,hypothesis,
%    [--greek(A,B,C),
%     --latin(A,B,D),
%     --greek(E,F,C),
%     --latin(E,F,D),
%     ++eq(F,B)]).
%input_clause(no_two_same2,theorem,
%    [--greek(A,B,C),
%     --latin(A,B,D),
%     --greek(E,F,C),
%     --latin(E,F,D),
%     ++eq(E,A)]).
%--------------------------------------------------------------------------
