%--------------------------------------------------------------------------
% File     : MSC008=LatSq-1.010 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : The constructability of a Graeco-Latin Square
% Version  : Theorem formulation : A 10x10 square.
% English  : The constructibility of Graeco-Latin squares of order 4t+2. 
%            This is impossible for t=0,1, but possible for all other 
%            cases.

% Refs     : Robinson J.A. (1963), Theorem Proving on the Computer, Journal 
%            of the ACM 10(2), ACM Press, New York, NY, 163-174.
% Source   : [TPTP]
% Names    : 

% Status   : satisfiable
% Syntax   : Number of clauses           :   61 (   6 non-Horn)(  46 unit)
%            Number of literals          :  136 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :   10 (  10 constant)
%            Number of variables         :   51 (   0 singleton)
%            Maximal clause size         :   10
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(p1_is_not_p2,axiom,
    [--eq(p1,p2)]).

input_clause(p1_is_not_p3,axiom,
    [--eq(p1,p3)]).

input_clause(p1_is_not_p4,axiom,
    [--eq(p1,p4)]).

input_clause(p1_is_not_p5,axiom,
    [--eq(p1,p5)]).

input_clause(p1_is_not_p6,axiom,
    [--eq(p1,p6)]).

input_clause(p1_is_not_p7,axiom,
    [--eq(p1,p7)]).

input_clause(p1_is_not_p8,axiom,
    [--eq(p1,p8)]).

input_clause(p1_is_not_p9,axiom,
    [--eq(p1,p9)]).

input_clause(p1_is_not_p10,axiom,
    [--eq(p1,p10)]).

input_clause(p2_is_not_p3,axiom,
    [--eq(p2,p3)]).

input_clause(p2_is_not_p4,axiom,
    [--eq(p2,p4)]).

input_clause(p2_is_not_p5,axiom,
    [--eq(p2,p5)]).

input_clause(p2_is_not_p6,axiom,
    [--eq(p2,p6)]).

input_clause(p2_is_not_p7,axiom,
    [--eq(p2,p7)]).

input_clause(p2_is_not_p8,axiom,
    [--eq(p2,p8)]).

input_clause(p2_is_not_p9,axiom,
    [--eq(p2,p9)]).

input_clause(p2_is_not_p10,axiom,
    [--eq(p2,p10)]).

input_clause(p3_is_not_p4,axiom,
    [--eq(p3,p4)]).

input_clause(p3_is_not_p5,axiom,
    [--eq(p3,p5)]).

input_clause(p3_is_not_p6,axiom,
    [--eq(p3,p6)]).

input_clause(p3_is_not_p7,axiom,
    [--eq(p3,p7)]).

input_clause(p3_is_not_p8,axiom,
    [--eq(p3,p8)]).

input_clause(p3_is_not_p9,axiom,
    [--eq(p3,p9)]).

input_clause(p3_is_not_p10,axiom,
    [--eq(p3,p10)]).

input_clause(p4_is_not_p5,axiom,
    [--eq(p4,p5)]).

input_clause(p4_is_not_p6,axiom,
    [--eq(p4,p6)]).

input_clause(p4_is_not_p7,axiom,
    [--eq(p4,p7)]).

input_clause(p4_is_not_p8,axiom,
    [--eq(p4,p8)]).

input_clause(p4_is_not_p9,axiom,
    [--eq(p4,p9)]).

input_clause(p4_is_not_p10,axiom,
    [--eq(p4,p10)]).

input_clause(p5_is_not_p6,axiom,
    [--eq(p5,p6)]).

input_clause(p5_is_not_p7,axiom,
    [--eq(p5,p7)]).

input_clause(p5_is_not_p8,axiom,
    [--eq(p5,p8)]).

input_clause(p5_is_not_p9,axiom,
    [--eq(p5,p9)]).

input_clause(p5_is_not_p10,axiom,
    [--eq(p5,p10)]).

input_clause(p6_is_not_p7,axiom,
    [--eq(p6,p7)]).

input_clause(p6_is_not_p8,axiom,
    [--eq(p6,p8)]).

input_clause(p6_is_not_p9,axiom,
    [--eq(p6,p9)]).

input_clause(p6_is_not_p10,axiom,
    [--eq(p6,p10)]).

input_clause(p7_is_not_p8,axiom,
    [--eq(p7,p8)]).

input_clause(p7_is_not_p9,axiom,
    [--eq(p7,p9)]).

input_clause(p7_is_not_p10,axiom,
    [--eq(p7,p10)]).

input_clause(p8_is_not_p9,axiom,
    [--eq(p8,p9)]).

input_clause(p8_is_not_p10,axiom,
    [--eq(p8,p10)]).

input_clause(p9_is_not_p10,axiom,
    [--eq(p9,p10)]).

input_clause(reflexivity,axiom,
    [++eq(A,A)]).

input_clause(symmetry,axiom,
    [--eq(A,B),
     ++eq(B,A)]).

input_clause(latin_element_is_unique,axiom,
    [--latin(A,B,C),
     --latin(A,B,D),
     ++eq(D,C)]).

input_clause(latin_column_is_unique,axiom,
    [--latin(A,B,C),
     --latin(A,D,C),
     ++eq(D,B)]).

input_clause(latin_row_is_unique,axiom,
    [--latin(A,B,C),
     --latin(D,B,C),
     ++eq(D,A)]).

input_clause(greek_element_is_unique,axiom,
    [--greek(A,B,C),
     --greek(A,B,D),
     ++eq(D,C)]).

input_clause(greek_column_is_unique,axiom,
    [--greek(A,B,C),
     --greek(A,D,C),
     ++eq(D,B)]).

input_clause(greek_row_is_unique,axiom,
    [--greek(A,B,C),
     --greek(D,B,C),
     ++eq(D,A)]).

input_clause(latin_cell_element,axiom,
    [++latin(E,F,p1),
     ++latin(E,F,p2),
     ++latin(E,F,p3),
     ++latin(E,F,p4),
     ++latin(E,F,p5),
     ++latin(E,F,p6),
     ++latin(E,F,p7),
     ++latin(E,F,p8),
     ++latin(E,F,p9),
     ++latin(E,F,p10)]).

input_clause(latin_column_required,axiom,
    [++latin(G,p1,H),
     ++latin(G,p2,H),
     ++latin(G,p3,H),
     ++latin(G,p4,H),
     ++latin(G,p5,H),
     ++latin(G,p6,H),
     ++latin(G,p7,H),
     ++latin(G,p8,H),
     ++latin(G,p9,H),
     ++latin(G,p10,H)]).

input_clause(latin_row_required,axiom,
    [++latin(p1,I,J),
     ++latin(p2,I,J),
     ++latin(p3,I,J),
     ++latin(p4,I,J),
     ++latin(p5,I,J),
     ++latin(p6,I,J),
     ++latin(p7,I,J),
     ++latin(p8,I,J),
     ++latin(p9,I,J),
     ++latin(p10,I,J)]).

input_clause(greek_cell_element,axiom,
    [++greek(K,L,p1),
     ++greek(K,L,p2),
     ++greek(K,L,p3),
     ++greek(K,L,p4),
     ++greek(K,L,p5),
     ++greek(K,L,p6),
     ++greek(K,L,p7),
     ++greek(K,L,p8),
     ++greek(K,L,p9),
     ++greek(K,L,p10)]).

input_clause(greek_column_required,axiom,
    [++greek(M,p1,N),
     ++greek(M,p2,N),
     ++greek(M,p3,N),
     ++greek(M,p4,N),
     ++greek(M,p5,N),
     ++greek(M,p6,N),
     ++greek(M,p7,N),
     ++greek(M,p8,N),
     ++greek(M,p9,N),
     ++greek(M,p10,N)]).

input_clause(greek_row_required,axiom,
    [++greek(p1,O,P),
     ++greek(p2,O,P),
     ++greek(p3,O,P),
     ++greek(p4,O,P),
     ++greek(p5,O,P),
     ++greek(p6,O,P),
     ++greek(p7,O,P),
     ++greek(p8,O,P),
     ++greek(p9,O,P),
     ++greek(p10,O,P)]).

input_clause(no_two_same1,theorem,
    [--greek(Q,R,S),
     --latin(Q,R,T),
     --greek(U,V,S),
     --latin(U,V,T),
     ++eq(V,R)]).

input_clause(no_two_same2,theorem,
    [--greek(Q,R,S),
     --latin(Q,R,T),
     --greek(U,V,S),
     --latin(U,V,T),
     ++eq(U,Q)]).
%--------------------------------------------------------------------------
