%--------------------------------------------------------------------------
% File     : MSC008=LatSq-1.006 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : The inconstructability of a Graeco-Latin Square
% Version  : Theorem formulation : A 6x6 square.
% English  : The constructibility of Graeco-Latin squares of order 4t+2. 
%            This is impossible for t=0,1, but possible for all other 
%            cases.

% Refs     : Robinson J.A. (1963), Theorem Proving on the Computer, Journal 
%            of the ACM 10(2), ACM Press, New York, NY, 163-174.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   31 (   6 non-Horn)(  16 unit)
%            Number of literals          :   82 (   0 equality)
%            Number of predicate symbols :    3 (   0 propositional)
%            Number of function symbols  :    6 (   6 constant)
%            Number of variables         :   51 (   0 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    1

% Comments : 
%--------------------------------------------------------------------------
input_clause(p1_is_not_p2,axiom,
    [--eq(p1,p2)]).

input_clause(p1_is_not_p3,axiom,
    [--eq(p1,p3)]).

input_clause(p1_is_not_p4,axiom,
    [--eq(p1,p4)]).

input_clause(p1_is_not_p5,axiom,
    [--eq(p1,p5)]).

input_clause(p1_is_not_p6,axiom,
    [--eq(p1,p6)]).

input_clause(p2_is_not_p3,axiom,
    [--eq(p2,p3)]).

input_clause(p2_is_not_p4,axiom,
    [--eq(p2,p4)]).

input_clause(p2_is_not_p5,axiom,
    [--eq(p2,p5)]).

input_clause(p2_is_not_p6,axiom,
    [--eq(p2,p6)]).

input_clause(p3_is_not_p4,axiom,
    [--eq(p3,p4)]).

input_clause(p3_is_not_p5,axiom,
    [--eq(p3,p5)]).

input_clause(p3_is_not_p6,axiom,
    [--eq(p3,p6)]).

input_clause(p4_is_not_p5,axiom,
    [--eq(p4,p5)]).

input_clause(p4_is_not_p6,axiom,
    [--eq(p4,p6)]).

input_clause(p5_is_not_p6,axiom,
    [--eq(p5,p6)]).

input_clause(reflexivity,axiom,
    [++eq(A,A)]).

input_clause(symmetry,axiom,
    [--eq(A,B),
     ++eq(B,A)]).

input_clause(latin_element_is_unique,axiom,
    [--latin(A,B,C),
     --latin(A,B,D),
     ++eq(D,C)]).

input_clause(latin_column_is_unique,axiom,
    [--latin(A,B,C),
     --latin(A,D,C),
     ++eq(D,B)]).

input_clause(latin_row_is_unique,axiom,
    [--latin(A,B,C),
     --latin(D,B,C),
     ++eq(D,A)]).

input_clause(greek_element_is_unique,axiom,
    [--greek(A,B,C),
     --greek(A,B,D),
     ++eq(D,C)]).

input_clause(greek_column_is_unique,axiom,
    [--greek(A,B,C),
     --greek(A,D,C),
     ++eq(D,B)]).

input_clause(greek_row_is_unique,axiom,
    [--greek(A,B,C),
     --greek(D,B,C),
     ++eq(D,A)]).

input_clause(latin_cell_element,axiom,
    [++latin(E,F,p1),
     ++latin(E,F,p2),
     ++latin(E,F,p3),
     ++latin(E,F,p4),
     ++latin(E,F,p5),
     ++latin(E,F,p6)]).

input_clause(latin_column_required,axiom,
    [++latin(G,p1,H),
     ++latin(G,p2,H),
     ++latin(G,p3,H),
     ++latin(G,p4,H),
     ++latin(G,p5,H),
     ++latin(G,p6,H)]).

input_clause(latin_row_required,axiom,
    [++latin(p1,I,J),
     ++latin(p2,I,J),
     ++latin(p3,I,J),
     ++latin(p4,I,J),
     ++latin(p5,I,J),
     ++latin(p6,I,J)]).

input_clause(greek_cell_element,axiom,
    [++greek(K,L,p1),
     ++greek(K,L,p2),
     ++greek(K,L,p3),
     ++greek(K,L,p4),
     ++greek(K,L,p5),
     ++greek(K,L,p6)]).

input_clause(greek_column_required,axiom,
    [++greek(M,p1,N),
     ++greek(M,p2,N),
     ++greek(M,p3,N),
     ++greek(M,p4,N),
     ++greek(M,p5,N),
     ++greek(M,p6,N)]).

input_clause(greek_row_required,axiom,
    [++greek(p1,O,P),
     ++greek(p2,O,P),
     ++greek(p3,O,P),
     ++greek(p4,O,P),
     ++greek(p5,O,P),
     ++greek(p6,O,P)]).

input_clause(no_two_same1,theorem,
    [--greek(Q,R,S),
     --latin(Q,R,T),
     --greek(U,V,S),
     --latin(U,V,T),
     ++eq(V,R)]).

input_clause(no_two_same2,theorem,
    [--greek(Q,R,S),
     --latin(Q,R,T),
     --greek(U,V,S),
     --latin(U,V,T),
     ++eq(U,Q)]).
%--------------------------------------------------------------------------
