%--------------------------------------------------------------------------
% File     : MSC007=Pigeon-2.007 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : Cook pigeon-hole problem
% Version  : Theorem formulation : 1st order; 7 pigeons.
% English  : Suppose there are N holes and N+1 pigeons to put in the 
%            holes. Every pigeon is in a hole and no hole contains more 
%            than one pigeon. Prove that this is impossible.

% Refs     : Cook S. and Reckhow R. (1979), The Relative Efficiency 
%            of Propositional Proof Systems, Journal of Symbolic Logic 44, 
%            36-50.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   61 (   1 non-Horn)(  50 unit)
%            Number of literals          :   86 (  55 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   14 (  13 constant)
%            Number of variables         :   24 (   0 singleton)
%            Maximal clause size         :    7
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(pigeon_substitutivity1,axiom,
    [--equal(K,L),
     --pigeon(K),
     ++pigeon(L)]).

input_clause(hole_of_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(hole_of(A),hole_of(B))]).

input_clause(hole_substitutivity1,axiom,
    [--equal(C,D),
     --hole(C),
     ++hole(D)]).

input_clause(in_substitutivity1,axiom,
    [--equal(E,F),
     --in(E,G),
     ++in(F,G)]).

input_clause(in_substitutivity2,axiom,
    [--equal(H,I),
     --in(J,H),
     ++in(J,I)]).

input_clause(pigeon1,theorem,
    [++pigeon(pigeon1)]).

input_clause(pigeon2,theorem,
    [++pigeon(pigeon2)]).

input_clause(pigeon3,theorem,
    [++pigeon(pigeon3)]).

input_clause(pigeon4,theorem,
    [++pigeon(pigeon4)]).

input_clause(pigeon5,theorem,
    [++pigeon(pigeon5)]).

input_clause(pigeon6,theorem,
    [++pigeon(pigeon6)]).

input_clause(pigeon7,theorem,
    [++pigeon(pigeon7)]).

input_clause(pigeon1_not_pigeon2,theorem,
    [--equal(pigeon1,pigeon2)]).

input_clause(pigeon1_not_pigeon3,theorem,
    [--equal(pigeon1,pigeon3)]).

input_clause(pigeon1_not_pigeon4,theorem,
    [--equal(pigeon1,pigeon4)]).

input_clause(pigeon1_not_pigeon5,theorem,
    [--equal(pigeon1,pigeon5)]).

input_clause(pigeon1_not_pigeon6,theorem,
    [--equal(pigeon1,pigeon6)]).

input_clause(pigeon1_not_pigeon7,theorem,
    [--equal(pigeon1,pigeon7)]).

input_clause(pigeon2_not_pigeon3,theorem,
    [--equal(pigeon2,pigeon3)]).

input_clause(pigeon2_not_pigeon4,theorem,
    [--equal(pigeon2,pigeon4)]).

input_clause(pigeon2_not_pigeon5,theorem,
    [--equal(pigeon2,pigeon5)]).

input_clause(pigeon2_not_pigeon6,theorem,
    [--equal(pigeon2,pigeon6)]).

input_clause(pigeon2_not_pigeon7,theorem,
    [--equal(pigeon2,pigeon7)]).

input_clause(pigeon3_not_pigeon4,theorem,
    [--equal(pigeon3,pigeon4)]).

input_clause(pigeon3_not_pigeon5,theorem,
    [--equal(pigeon3,pigeon5)]).

input_clause(pigeon3_not_pigeon6,theorem,
    [--equal(pigeon3,pigeon6)]).

input_clause(pigeon3_not_pigeon7,theorem,
    [--equal(pigeon3,pigeon7)]).

input_clause(pigeon4_not_pigeon5,theorem,
    [--equal(pigeon4,pigeon5)]).

input_clause(pigeon4_not_pigeon6,theorem,
    [--equal(pigeon4,pigeon6)]).

input_clause(pigeon4_not_pigeon7,theorem,
    [--equal(pigeon4,pigeon7)]).

input_clause(pigeon5_not_pigeon6,theorem,
    [--equal(pigeon5,pigeon6)]).

input_clause(pigeon5_not_pigeon7,theorem,
    [--equal(pigeon5,pigeon7)]).

input_clause(pigeon6_not_pigeon7,theorem,
    [--equal(pigeon6,pigeon7)]).

input_clause(hole1,theorem,
    [++hole(hole1)]).

input_clause(hole2,theorem,
    [++hole(hole2)]).

input_clause(hole3,theorem,
    [++hole(hole3)]).

input_clause(hole4,theorem,
    [++hole(hole4)]).

input_clause(hole5,theorem,
    [++hole(hole5)]).

input_clause(hole6,theorem,
    [++hole(hole6)]).

input_clause(hole1_not_hole2,theorem,
    [--equal(hole1,hole2)]).

input_clause(hole1_not_hole3,theorem,
    [--equal(hole1,hole3)]).

input_clause(hole1_not_hole4,theorem,
    [--equal(hole1,hole4)]).

input_clause(hole1_not_hole5,theorem,
    [--equal(hole1,hole5)]).

input_clause(hole1_not_hole6,theorem,
    [--equal(hole1,hole6)]).

input_clause(hole2_not_hole3,theorem,
    [--equal(hole2,hole3)]).

input_clause(hole2_not_hole4,theorem,
    [--equal(hole2,hole4)]).

input_clause(hole2_not_hole5,theorem,
    [--equal(hole2,hole5)]).

input_clause(hole2_not_hole6,theorem,
    [--equal(hole2,hole6)]).

input_clause(hole3_not_hole4,theorem,
    [--equal(hole3,hole4)]).

input_clause(hole3_not_hole5,theorem,
    [--equal(hole3,hole5)]).

input_clause(hole3_not_hole6,theorem,
    [--equal(hole3,hole6)]).

input_clause(hole4_not_hole5,theorem,
    [--equal(hole4,hole5)]).

input_clause(hole4_not_hole6,theorem,
    [--equal(hole4,hole6)]).

input_clause(hole5_not_hole6,theorem,
    [--equal(hole5,hole6)]).

input_clause(all_holes,theorem,
    [--hole(A),
     ++equal(A,hole1),
     ++equal(A,hole2),
     ++equal(A,hole3),
     ++equal(A,hole4),
     ++equal(A,hole5),
     ++equal(A,hole6)]).

input_clause(each_pigeons_hole1,theorem,
    [--pigeon(B),
     ++hole(hole_of(B))]).

input_clause(each_pigeons_hole2,theorem,
    [--pigeon(B),
     ++in(B,hole_of(B))]).

input_clause(only_one_per_hole,theorem,
    [--hole(C),
     --pigeon(D),
     --pigeon(E),
     --in(D,C),
     --in(E,C),
     ++equal(D,E)]).
%--------------------------------------------------------------------------
