%--------------------------------------------------------------------------
% File     : MSC007=Pigeon-2.002 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : Cook pigeon-hole problem
% Version  : Theorem formulation : 1st order; 2 pigeons.
% English  : Suppose there are N holes and N+1 pigeons to put in the 
%            holes. Every pigeon is in a hole and no hole contains more 
%            than one pigeon. Prove that this is impossible.

% Refs     : Cook S. and Reckhow R. (1979), The Relative Efficiency 
%            of Propositional Proof Systems, Journal of Symbolic Logic 44, 
%            36-50.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   16 (   0 non-Horn)(   5 unit)
%            Number of literals          :   36 (  15 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :   24 (   0 singleton)
%            Maximal clause size         :    6
%            Maximal term depth          :    2

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
input_clause(pigeon_substitutivity1,axiom,
    [--equal(K,L),
     --pigeon(K),
     ++pigeon(L)]).

input_clause(hole_of_substitutivity1,axiom,
    [--equal(A,B),
     ++equal(hole_of(A),hole_of(B))]).

input_clause(hole_substitutivity1,axiom,
    [--equal(C,D),
     --hole(C),
     ++hole(D)]).

input_clause(in_substitutivity1,axiom,
    [--equal(E,F),
     --in(E,G),
     ++in(F,G)]).

input_clause(in_substitutivity2,axiom,
    [--equal(H,I),
     --in(J,H),
     ++in(J,I)]).

input_clause(pigeon1,theorem,
    [++pigeon(pigeon1)]).

input_clause(pigeon2,theorem,
    [++pigeon(pigeon2)]).

input_clause(pigeon1_not_pigeon2,theorem,
    [--equal(pigeon1,pigeon2)]).

input_clause(hole1,theorem,
    [++hole(hole1)]).

input_clause(all_holes,theorem,
    [--hole(A),
     ++equal(A,hole1)]).

input_clause(each_pigeons_hole1,theorem,
    [--pigeon(B),
     ++hole(hole_of(B))]).

input_clause(each_pigeons_hole2,theorem,
    [--pigeon(B),
     ++in(B,hole_of(B))]).

input_clause(only_one_per_hole,theorem,
    [--hole(C),
     --pigeon(D),
     --pigeon(E),
     --in(D,C),
     --in(E,C),
     ++equal(D,E)]).
%--------------------------------------------------------------------------
