%--------------------------------------------------------------------------
% File     : MSC007=Pigeon-1.012 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : Cook 1pigeon-hole problem
% Version  : Theorem formulation : Propositional; 12 pigeons.
% English  : Suppose there are N holes and N+1 pigeons to put in the 
%            holes. Every pigeon is in a hole and no hole contains more 
%            than one pigeon. Prove that this is impossible.

% Refs     : Cook S. and Reckhow R. (1979), The Relative Efficiency 
%            of Propositional Proof Systems, Journal of Symbolic Logic 44, 
%            36-50.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :  738 (  12 non-Horn)(   0 unit)
%            Number of literals          : 1584 (   0 equality)
%            Number of predicate symbols :  132 ( 132 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :   11
%            Maximal term depth          :    0

% Comments : For an N hole problem, the number of propositions 
%            is N^2 + N and the number of clauses is (N^3 + N^2)/2 + N+1. 
%            Thus the number of propositions increases quadratically and 
%            the number of clauses increases cubically.
%--------------------------------------------------------------------------
input_clause(pigeon_1,theorem,
    [++pigeon_1_in_hole_1,
     ++pigeon_1_in_hole_2,
     ++pigeon_1_in_hole_3,
     ++pigeon_1_in_hole_4,
     ++pigeon_1_in_hole_5,
     ++pigeon_1_in_hole_6,
     ++pigeon_1_in_hole_7,
     ++pigeon_1_in_hole_8,
     ++pigeon_1_in_hole_9,
     ++pigeon_1_in_hole_10,
     ++pigeon_1_in_hole_11]).

input_clause(pigeon_2,theorem,
    [++pigeon_2_in_hole_1,
     ++pigeon_2_in_hole_2,
     ++pigeon_2_in_hole_3,
     ++pigeon_2_in_hole_4,
     ++pigeon_2_in_hole_5,
     ++pigeon_2_in_hole_6,
     ++pigeon_2_in_hole_7,
     ++pigeon_2_in_hole_8,
     ++pigeon_2_in_hole_9,
     ++pigeon_2_in_hole_10,
     ++pigeon_2_in_hole_11]).

input_clause(pigeon_3,theorem,
    [++pigeon_3_in_hole_1,
     ++pigeon_3_in_hole_2,
     ++pigeon_3_in_hole_3,
     ++pigeon_3_in_hole_4,
     ++pigeon_3_in_hole_5,
     ++pigeon_3_in_hole_6,
     ++pigeon_3_in_hole_7,
     ++pigeon_3_in_hole_8,
     ++pigeon_3_in_hole_9,
     ++pigeon_3_in_hole_10,
     ++pigeon_3_in_hole_11]).

input_clause(pigeon_4,theorem,
    [++pigeon_4_in_hole_1,
     ++pigeon_4_in_hole_2,
     ++pigeon_4_in_hole_3,
     ++pigeon_4_in_hole_4,
     ++pigeon_4_in_hole_5,
     ++pigeon_4_in_hole_6,
     ++pigeon_4_in_hole_7,
     ++pigeon_4_in_hole_8,
     ++pigeon_4_in_hole_9,
     ++pigeon_4_in_hole_10,
     ++pigeon_4_in_hole_11]).

input_clause(pigeon_5,theorem,
    [++pigeon_5_in_hole_1,
     ++pigeon_5_in_hole_2,
     ++pigeon_5_in_hole_3,
     ++pigeon_5_in_hole_4,
     ++pigeon_5_in_hole_5,
     ++pigeon_5_in_hole_6,
     ++pigeon_5_in_hole_7,
     ++pigeon_5_in_hole_8,
     ++pigeon_5_in_hole_9,
     ++pigeon_5_in_hole_10,
     ++pigeon_5_in_hole_11]).

input_clause(pigeon_6,theorem,
    [++pigeon_6_in_hole_1,
     ++pigeon_6_in_hole_2,
     ++pigeon_6_in_hole_3,
     ++pigeon_6_in_hole_4,
     ++pigeon_6_in_hole_5,
     ++pigeon_6_in_hole_6,
     ++pigeon_6_in_hole_7,
     ++pigeon_6_in_hole_8,
     ++pigeon_6_in_hole_9,
     ++pigeon_6_in_hole_10,
     ++pigeon_6_in_hole_11]).

input_clause(pigeon_7,theorem,
    [++pigeon_7_in_hole_1,
     ++pigeon_7_in_hole_2,
     ++pigeon_7_in_hole_3,
     ++pigeon_7_in_hole_4,
     ++pigeon_7_in_hole_5,
     ++pigeon_7_in_hole_6,
     ++pigeon_7_in_hole_7,
     ++pigeon_7_in_hole_8,
     ++pigeon_7_in_hole_9,
     ++pigeon_7_in_hole_10,
     ++pigeon_7_in_hole_11]).

input_clause(pigeon_8,theorem,
    [++pigeon_8_in_hole_1,
     ++pigeon_8_in_hole_2,
     ++pigeon_8_in_hole_3,
     ++pigeon_8_in_hole_4,
     ++pigeon_8_in_hole_5,
     ++pigeon_8_in_hole_6,
     ++pigeon_8_in_hole_7,
     ++pigeon_8_in_hole_8,
     ++pigeon_8_in_hole_9,
     ++pigeon_8_in_hole_10,
     ++pigeon_8_in_hole_11]).

input_clause(pigeon_9,theorem,
    [++pigeon_9_in_hole_1,
     ++pigeon_9_in_hole_2,
     ++pigeon_9_in_hole_3,
     ++pigeon_9_in_hole_4,
     ++pigeon_9_in_hole_5,
     ++pigeon_9_in_hole_6,
     ++pigeon_9_in_hole_7,
     ++pigeon_9_in_hole_8,
     ++pigeon_9_in_hole_9,
     ++pigeon_9_in_hole_10,
     ++pigeon_9_in_hole_11]).

input_clause(pigeon_10,theorem,
    [++pigeon_10_in_hole_1,
     ++pigeon_10_in_hole_2,
     ++pigeon_10_in_hole_3,
     ++pigeon_10_in_hole_4,
     ++pigeon_10_in_hole_5,
     ++pigeon_10_in_hole_6,
     ++pigeon_10_in_hole_7,
     ++pigeon_10_in_hole_8,
     ++pigeon_10_in_hole_9,
     ++pigeon_10_in_hole_10,
     ++pigeon_10_in_hole_11]).

input_clause(pigeon_11,theorem,
    [++pigeon_11_in_hole_1,
     ++pigeon_11_in_hole_2,
     ++pigeon_11_in_hole_3,
     ++pigeon_11_in_hole_4,
     ++pigeon_11_in_hole_5,
     ++pigeon_11_in_hole_6,
     ++pigeon_11_in_hole_7,
     ++pigeon_11_in_hole_8,
     ++pigeon_11_in_hole_9,
     ++pigeon_11_in_hole_10,
     ++pigeon_11_in_hole_11]).

input_clause(pigeon_12,theorem,
    [++pigeon_12_in_hole_1,
     ++pigeon_12_in_hole_2,
     ++pigeon_12_in_hole_3,
     ++pigeon_12_in_hole_4,
     ++pigeon_12_in_hole_5,
     ++pigeon_12_in_hole_6,
     ++pigeon_12_in_hole_7,
     ++pigeon_12_in_hole_8,
     ++pigeon_12_in_hole_9,
     ++pigeon_12_in_hole_10,
     ++pigeon_12_in_hole_11]).

input_clause(hole_1_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_1,--pigeon_2_in_hole_1]).

input_clause(hole_1_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_1,--pigeon_3_in_hole_1]).

input_clause(hole_1_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_1,--pigeon_4_in_hole_1]).

input_clause(hole_1_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_1,--pigeon_5_in_hole_1]).

input_clause(hole_1_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_1,--pigeon_6_in_hole_1]).

input_clause(hole_1_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_1,--pigeon_7_in_hole_1]).

input_clause(hole_1_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_1,--pigeon_8_in_hole_1]).

input_clause(hole_1_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_1,--pigeon_9_in_hole_1]).

input_clause(hole_1_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_1,--pigeon_10_in_hole_1]).

input_clause(hole_1_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_1,--pigeon_11_in_hole_1]).

input_clause(hole_1_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_1_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_1,--pigeon_3_in_hole_1]).

input_clause(hole_1_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_1,--pigeon_4_in_hole_1]).

input_clause(hole_1_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_1,--pigeon_5_in_hole_1]).

input_clause(hole_1_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_1,--pigeon_6_in_hole_1]).

input_clause(hole_1_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_1,--pigeon_7_in_hole_1]).

input_clause(hole_1_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_1,--pigeon_8_in_hole_1]).

input_clause(hole_1_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_1,--pigeon_9_in_hole_1]).

input_clause(hole_1_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_1,--pigeon_10_in_hole_1]).

input_clause(hole_1_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_1,--pigeon_11_in_hole_1]).

input_clause(hole_1_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_1_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_1,--pigeon_4_in_hole_1]).

input_clause(hole_1_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_1,--pigeon_5_in_hole_1]).

input_clause(hole_1_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_1,--pigeon_6_in_hole_1]).

input_clause(hole_1_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_1,--pigeon_7_in_hole_1]).

input_clause(hole_1_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_1,--pigeon_8_in_hole_1]).

input_clause(hole_1_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_1,--pigeon_9_in_hole_1]).

input_clause(hole_1_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_1,--pigeon_10_in_hole_1]).

input_clause(hole_1_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_1,--pigeon_11_in_hole_1]).

input_clause(hole_1_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_1_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_1,--pigeon_5_in_hole_1]).

input_clause(hole_1_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_1,--pigeon_6_in_hole_1]).

input_clause(hole_1_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_1,--pigeon_7_in_hole_1]).

input_clause(hole_1_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_1,--pigeon_8_in_hole_1]).

input_clause(hole_1_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_1,--pigeon_9_in_hole_1]).

input_clause(hole_1_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_1,--pigeon_10_in_hole_1]).

input_clause(hole_1_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_1,--pigeon_11_in_hole_1]).

input_clause(hole_1_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_1_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_1,--pigeon_6_in_hole_1]).

input_clause(hole_1_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_1,--pigeon_7_in_hole_1]).

input_clause(hole_1_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_1,--pigeon_8_in_hole_1]).

input_clause(hole_1_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_1,--pigeon_9_in_hole_1]).

input_clause(hole_1_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_1,--pigeon_10_in_hole_1]).

input_clause(hole_1_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_1,--pigeon_11_in_hole_1]).

input_clause(hole_1_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_1_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_1,--pigeon_7_in_hole_1]).

input_clause(hole_1_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_1,--pigeon_8_in_hole_1]).

input_clause(hole_1_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_1,--pigeon_9_in_hole_1]).

input_clause(hole_1_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_1,--pigeon_10_in_hole_1]).

input_clause(hole_1_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_1,--pigeon_11_in_hole_1]).

input_clause(hole_1_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_1_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_1,--pigeon_8_in_hole_1]).

input_clause(hole_1_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_1,--pigeon_9_in_hole_1]).

input_clause(hole_1_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_1,--pigeon_10_in_hole_1]).

input_clause(hole_1_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_1,--pigeon_11_in_hole_1]).

input_clause(hole_1_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_1_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_1,--pigeon_9_in_hole_1]).

input_clause(hole_1_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_1,--pigeon_10_in_hole_1]).

input_clause(hole_1_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_1,--pigeon_11_in_hole_1]).

input_clause(hole_1_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_1_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_1,--pigeon_10_in_hole_1]).

input_clause(hole_1_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_1,--pigeon_11_in_hole_1]).

input_clause(hole_1_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_1_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_1,--pigeon_11_in_hole_1]).

input_clause(hole_1_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_1_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_1,--pigeon_12_in_hole_1]).

input_clause(hole_2_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_2,--pigeon_2_in_hole_2]).

input_clause(hole_2_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_2,--pigeon_3_in_hole_2]).

input_clause(hole_2_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_2,--pigeon_4_in_hole_2]).

input_clause(hole_2_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_2,--pigeon_5_in_hole_2]).

input_clause(hole_2_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_2,--pigeon_6_in_hole_2]).

input_clause(hole_2_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_2,--pigeon_7_in_hole_2]).

input_clause(hole_2_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_2,--pigeon_8_in_hole_2]).

input_clause(hole_2_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_2,--pigeon_9_in_hole_2]).

input_clause(hole_2_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_2,--pigeon_10_in_hole_2]).

input_clause(hole_2_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_2,--pigeon_11_in_hole_2]).

input_clause(hole_2_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_2_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_2,--pigeon_3_in_hole_2]).

input_clause(hole_2_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_2,--pigeon_4_in_hole_2]).

input_clause(hole_2_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_2,--pigeon_5_in_hole_2]).

input_clause(hole_2_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_2,--pigeon_6_in_hole_2]).

input_clause(hole_2_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_2,--pigeon_7_in_hole_2]).

input_clause(hole_2_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_2,--pigeon_8_in_hole_2]).

input_clause(hole_2_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_2,--pigeon_9_in_hole_2]).

input_clause(hole_2_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_2,--pigeon_10_in_hole_2]).

input_clause(hole_2_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_2,--pigeon_11_in_hole_2]).

input_clause(hole_2_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_2_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_2,--pigeon_4_in_hole_2]).

input_clause(hole_2_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_2,--pigeon_5_in_hole_2]).

input_clause(hole_2_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_2,--pigeon_6_in_hole_2]).

input_clause(hole_2_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_2,--pigeon_7_in_hole_2]).

input_clause(hole_2_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_2,--pigeon_8_in_hole_2]).

input_clause(hole_2_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_2,--pigeon_9_in_hole_2]).

input_clause(hole_2_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_2,--pigeon_10_in_hole_2]).

input_clause(hole_2_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_2,--pigeon_11_in_hole_2]).

input_clause(hole_2_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_2_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_2,--pigeon_5_in_hole_2]).

input_clause(hole_2_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_2,--pigeon_6_in_hole_2]).

input_clause(hole_2_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_2,--pigeon_7_in_hole_2]).

input_clause(hole_2_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_2,--pigeon_8_in_hole_2]).

input_clause(hole_2_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_2,--pigeon_9_in_hole_2]).

input_clause(hole_2_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_2,--pigeon_10_in_hole_2]).

input_clause(hole_2_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_2,--pigeon_11_in_hole_2]).

input_clause(hole_2_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_2_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_2,--pigeon_6_in_hole_2]).

input_clause(hole_2_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_2,--pigeon_7_in_hole_2]).

input_clause(hole_2_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_2,--pigeon_8_in_hole_2]).

input_clause(hole_2_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_2,--pigeon_9_in_hole_2]).

input_clause(hole_2_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_2,--pigeon_10_in_hole_2]).

input_clause(hole_2_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_2,--pigeon_11_in_hole_2]).

input_clause(hole_2_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_2_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_2,--pigeon_7_in_hole_2]).

input_clause(hole_2_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_2,--pigeon_8_in_hole_2]).

input_clause(hole_2_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_2,--pigeon_9_in_hole_2]).

input_clause(hole_2_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_2,--pigeon_10_in_hole_2]).

input_clause(hole_2_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_2,--pigeon_11_in_hole_2]).

input_clause(hole_2_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_2_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_2,--pigeon_8_in_hole_2]).

input_clause(hole_2_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_2,--pigeon_9_in_hole_2]).

input_clause(hole_2_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_2,--pigeon_10_in_hole_2]).

input_clause(hole_2_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_2,--pigeon_11_in_hole_2]).

input_clause(hole_2_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_2_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_2,--pigeon_9_in_hole_2]).

input_clause(hole_2_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_2,--pigeon_10_in_hole_2]).

input_clause(hole_2_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_2,--pigeon_11_in_hole_2]).

input_clause(hole_2_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_2_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_2,--pigeon_10_in_hole_2]).

input_clause(hole_2_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_2,--pigeon_11_in_hole_2]).

input_clause(hole_2_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_2_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_2,--pigeon_11_in_hole_2]).

input_clause(hole_2_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_2_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_2,--pigeon_12_in_hole_2]).

input_clause(hole_3_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_3,--pigeon_2_in_hole_3]).

input_clause(hole_3_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_3,--pigeon_3_in_hole_3]).

input_clause(hole_3_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_3,--pigeon_4_in_hole_3]).

input_clause(hole_3_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_3,--pigeon_5_in_hole_3]).

input_clause(hole_3_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_3,--pigeon_6_in_hole_3]).

input_clause(hole_3_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_3,--pigeon_7_in_hole_3]).

input_clause(hole_3_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_3,--pigeon_8_in_hole_3]).

input_clause(hole_3_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_3,--pigeon_9_in_hole_3]).

input_clause(hole_3_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_3,--pigeon_10_in_hole_3]).

input_clause(hole_3_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_3,--pigeon_11_in_hole_3]).

input_clause(hole_3_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_3_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_3,--pigeon_3_in_hole_3]).

input_clause(hole_3_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_3,--pigeon_4_in_hole_3]).

input_clause(hole_3_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_3,--pigeon_5_in_hole_3]).

input_clause(hole_3_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_3,--pigeon_6_in_hole_3]).

input_clause(hole_3_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_3,--pigeon_7_in_hole_3]).

input_clause(hole_3_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_3,--pigeon_8_in_hole_3]).

input_clause(hole_3_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_3,--pigeon_9_in_hole_3]).

input_clause(hole_3_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_3,--pigeon_10_in_hole_3]).

input_clause(hole_3_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_3,--pigeon_11_in_hole_3]).

input_clause(hole_3_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_3_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_3,--pigeon_4_in_hole_3]).

input_clause(hole_3_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_3,--pigeon_5_in_hole_3]).

input_clause(hole_3_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_3,--pigeon_6_in_hole_3]).

input_clause(hole_3_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_3,--pigeon_7_in_hole_3]).

input_clause(hole_3_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_3,--pigeon_8_in_hole_3]).

input_clause(hole_3_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_3,--pigeon_9_in_hole_3]).

input_clause(hole_3_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_3,--pigeon_10_in_hole_3]).

input_clause(hole_3_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_3,--pigeon_11_in_hole_3]).

input_clause(hole_3_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_3_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_3,--pigeon_5_in_hole_3]).

input_clause(hole_3_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_3,--pigeon_6_in_hole_3]).

input_clause(hole_3_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_3,--pigeon_7_in_hole_3]).

input_clause(hole_3_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_3,--pigeon_8_in_hole_3]).

input_clause(hole_3_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_3,--pigeon_9_in_hole_3]).

input_clause(hole_3_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_3,--pigeon_10_in_hole_3]).

input_clause(hole_3_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_3,--pigeon_11_in_hole_3]).

input_clause(hole_3_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_3_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_3,--pigeon_6_in_hole_3]).

input_clause(hole_3_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_3,--pigeon_7_in_hole_3]).

input_clause(hole_3_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_3,--pigeon_8_in_hole_3]).

input_clause(hole_3_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_3,--pigeon_9_in_hole_3]).

input_clause(hole_3_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_3,--pigeon_10_in_hole_3]).

input_clause(hole_3_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_3,--pigeon_11_in_hole_3]).

input_clause(hole_3_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_3_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_3,--pigeon_7_in_hole_3]).

input_clause(hole_3_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_3,--pigeon_8_in_hole_3]).

input_clause(hole_3_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_3,--pigeon_9_in_hole_3]).

input_clause(hole_3_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_3,--pigeon_10_in_hole_3]).

input_clause(hole_3_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_3,--pigeon_11_in_hole_3]).

input_clause(hole_3_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_3_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_3,--pigeon_8_in_hole_3]).

input_clause(hole_3_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_3,--pigeon_9_in_hole_3]).

input_clause(hole_3_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_3,--pigeon_10_in_hole_3]).

input_clause(hole_3_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_3,--pigeon_11_in_hole_3]).

input_clause(hole_3_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_3_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_3,--pigeon_9_in_hole_3]).

input_clause(hole_3_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_3,--pigeon_10_in_hole_3]).

input_clause(hole_3_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_3,--pigeon_11_in_hole_3]).

input_clause(hole_3_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_3_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_3,--pigeon_10_in_hole_3]).

input_clause(hole_3_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_3,--pigeon_11_in_hole_3]).

input_clause(hole_3_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_3_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_3,--pigeon_11_in_hole_3]).

input_clause(hole_3_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_3_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_3,--pigeon_12_in_hole_3]).

input_clause(hole_4_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_4,--pigeon_2_in_hole_4]).

input_clause(hole_4_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_4,--pigeon_3_in_hole_4]).

input_clause(hole_4_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_4,--pigeon_4_in_hole_4]).

input_clause(hole_4_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_4,--pigeon_5_in_hole_4]).

input_clause(hole_4_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_4,--pigeon_6_in_hole_4]).

input_clause(hole_4_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_4,--pigeon_7_in_hole_4]).

input_clause(hole_4_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_4,--pigeon_8_in_hole_4]).

input_clause(hole_4_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_4,--pigeon_9_in_hole_4]).

input_clause(hole_4_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_4,--pigeon_10_in_hole_4]).

input_clause(hole_4_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_4,--pigeon_11_in_hole_4]).

input_clause(hole_4_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_4_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_4,--pigeon_3_in_hole_4]).

input_clause(hole_4_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_4,--pigeon_4_in_hole_4]).

input_clause(hole_4_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_4,--pigeon_5_in_hole_4]).

input_clause(hole_4_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_4,--pigeon_6_in_hole_4]).

input_clause(hole_4_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_4,--pigeon_7_in_hole_4]).

input_clause(hole_4_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_4,--pigeon_8_in_hole_4]).

input_clause(hole_4_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_4,--pigeon_9_in_hole_4]).

input_clause(hole_4_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_4,--pigeon_10_in_hole_4]).

input_clause(hole_4_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_4,--pigeon_11_in_hole_4]).

input_clause(hole_4_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_4_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_4,--pigeon_4_in_hole_4]).

input_clause(hole_4_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_4,--pigeon_5_in_hole_4]).

input_clause(hole_4_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_4,--pigeon_6_in_hole_4]).

input_clause(hole_4_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_4,--pigeon_7_in_hole_4]).

input_clause(hole_4_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_4,--pigeon_8_in_hole_4]).

input_clause(hole_4_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_4,--pigeon_9_in_hole_4]).

input_clause(hole_4_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_4,--pigeon_10_in_hole_4]).

input_clause(hole_4_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_4,--pigeon_11_in_hole_4]).

input_clause(hole_4_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_4_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_4,--pigeon_5_in_hole_4]).

input_clause(hole_4_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_4,--pigeon_6_in_hole_4]).

input_clause(hole_4_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_4,--pigeon_7_in_hole_4]).

input_clause(hole_4_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_4,--pigeon_8_in_hole_4]).

input_clause(hole_4_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_4,--pigeon_9_in_hole_4]).

input_clause(hole_4_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_4,--pigeon_10_in_hole_4]).

input_clause(hole_4_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_4,--pigeon_11_in_hole_4]).

input_clause(hole_4_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_4_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_4,--pigeon_6_in_hole_4]).

input_clause(hole_4_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_4,--pigeon_7_in_hole_4]).

input_clause(hole_4_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_4,--pigeon_8_in_hole_4]).

input_clause(hole_4_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_4,--pigeon_9_in_hole_4]).

input_clause(hole_4_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_4,--pigeon_10_in_hole_4]).

input_clause(hole_4_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_4,--pigeon_11_in_hole_4]).

input_clause(hole_4_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_4_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_4,--pigeon_7_in_hole_4]).

input_clause(hole_4_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_4,--pigeon_8_in_hole_4]).

input_clause(hole_4_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_4,--pigeon_9_in_hole_4]).

input_clause(hole_4_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_4,--pigeon_10_in_hole_4]).

input_clause(hole_4_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_4,--pigeon_11_in_hole_4]).

input_clause(hole_4_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_4_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_4,--pigeon_8_in_hole_4]).

input_clause(hole_4_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_4,--pigeon_9_in_hole_4]).

input_clause(hole_4_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_4,--pigeon_10_in_hole_4]).

input_clause(hole_4_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_4,--pigeon_11_in_hole_4]).

input_clause(hole_4_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_4_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_4,--pigeon_9_in_hole_4]).

input_clause(hole_4_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_4,--pigeon_10_in_hole_4]).

input_clause(hole_4_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_4,--pigeon_11_in_hole_4]).

input_clause(hole_4_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_4_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_4,--pigeon_10_in_hole_4]).

input_clause(hole_4_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_4,--pigeon_11_in_hole_4]).

input_clause(hole_4_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_4_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_4,--pigeon_11_in_hole_4]).

input_clause(hole_4_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_4_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_4,--pigeon_12_in_hole_4]).

input_clause(hole_5_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_5,--pigeon_2_in_hole_5]).

input_clause(hole_5_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_5,--pigeon_3_in_hole_5]).

input_clause(hole_5_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_5,--pigeon_4_in_hole_5]).

input_clause(hole_5_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_5,--pigeon_5_in_hole_5]).

input_clause(hole_5_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_5,--pigeon_6_in_hole_5]).

input_clause(hole_5_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_5,--pigeon_7_in_hole_5]).

input_clause(hole_5_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_5,--pigeon_8_in_hole_5]).

input_clause(hole_5_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_5,--pigeon_9_in_hole_5]).

input_clause(hole_5_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_5,--pigeon_10_in_hole_5]).

input_clause(hole_5_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_5,--pigeon_11_in_hole_5]).

input_clause(hole_5_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_5_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_5,--pigeon_3_in_hole_5]).

input_clause(hole_5_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_5,--pigeon_4_in_hole_5]).

input_clause(hole_5_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_5,--pigeon_5_in_hole_5]).

input_clause(hole_5_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_5,--pigeon_6_in_hole_5]).

input_clause(hole_5_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_5,--pigeon_7_in_hole_5]).

input_clause(hole_5_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_5,--pigeon_8_in_hole_5]).

input_clause(hole_5_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_5,--pigeon_9_in_hole_5]).

input_clause(hole_5_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_5,--pigeon_10_in_hole_5]).

input_clause(hole_5_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_5,--pigeon_11_in_hole_5]).

input_clause(hole_5_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_5_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_5,--pigeon_4_in_hole_5]).

input_clause(hole_5_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_5,--pigeon_5_in_hole_5]).

input_clause(hole_5_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_5,--pigeon_6_in_hole_5]).

input_clause(hole_5_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_5,--pigeon_7_in_hole_5]).

input_clause(hole_5_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_5,--pigeon_8_in_hole_5]).

input_clause(hole_5_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_5,--pigeon_9_in_hole_5]).

input_clause(hole_5_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_5,--pigeon_10_in_hole_5]).

input_clause(hole_5_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_5,--pigeon_11_in_hole_5]).

input_clause(hole_5_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_5_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_5,--pigeon_5_in_hole_5]).

input_clause(hole_5_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_5,--pigeon_6_in_hole_5]).

input_clause(hole_5_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_5,--pigeon_7_in_hole_5]).

input_clause(hole_5_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_5,--pigeon_8_in_hole_5]).

input_clause(hole_5_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_5,--pigeon_9_in_hole_5]).

input_clause(hole_5_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_5,--pigeon_10_in_hole_5]).

input_clause(hole_5_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_5,--pigeon_11_in_hole_5]).

input_clause(hole_5_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_5_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_5,--pigeon_6_in_hole_5]).

input_clause(hole_5_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_5,--pigeon_7_in_hole_5]).

input_clause(hole_5_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_5,--pigeon_8_in_hole_5]).

input_clause(hole_5_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_5,--pigeon_9_in_hole_5]).

input_clause(hole_5_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_5,--pigeon_10_in_hole_5]).

input_clause(hole_5_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_5,--pigeon_11_in_hole_5]).

input_clause(hole_5_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_5_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_5,--pigeon_7_in_hole_5]).

input_clause(hole_5_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_5,--pigeon_8_in_hole_5]).

input_clause(hole_5_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_5,--pigeon_9_in_hole_5]).

input_clause(hole_5_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_5,--pigeon_10_in_hole_5]).

input_clause(hole_5_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_5,--pigeon_11_in_hole_5]).

input_clause(hole_5_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_5_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_5,--pigeon_8_in_hole_5]).

input_clause(hole_5_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_5,--pigeon_9_in_hole_5]).

input_clause(hole_5_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_5,--pigeon_10_in_hole_5]).

input_clause(hole_5_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_5,--pigeon_11_in_hole_5]).

input_clause(hole_5_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_5_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_5,--pigeon_9_in_hole_5]).

input_clause(hole_5_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_5,--pigeon_10_in_hole_5]).

input_clause(hole_5_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_5,--pigeon_11_in_hole_5]).

input_clause(hole_5_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_5_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_5,--pigeon_10_in_hole_5]).

input_clause(hole_5_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_5,--pigeon_11_in_hole_5]).

input_clause(hole_5_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_5_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_5,--pigeon_11_in_hole_5]).

input_clause(hole_5_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_5_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_5,--pigeon_12_in_hole_5]).

input_clause(hole_6_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_6,--pigeon_2_in_hole_6]).

input_clause(hole_6_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_6,--pigeon_3_in_hole_6]).

input_clause(hole_6_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_6,--pigeon_4_in_hole_6]).

input_clause(hole_6_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_6,--pigeon_5_in_hole_6]).

input_clause(hole_6_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_6,--pigeon_6_in_hole_6]).

input_clause(hole_6_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_6,--pigeon_7_in_hole_6]).

input_clause(hole_6_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_6,--pigeon_8_in_hole_6]).

input_clause(hole_6_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_6,--pigeon_9_in_hole_6]).

input_clause(hole_6_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_6,--pigeon_10_in_hole_6]).

input_clause(hole_6_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_6,--pigeon_11_in_hole_6]).

input_clause(hole_6_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_6_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_6,--pigeon_3_in_hole_6]).

input_clause(hole_6_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_6,--pigeon_4_in_hole_6]).

input_clause(hole_6_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_6,--pigeon_5_in_hole_6]).

input_clause(hole_6_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_6,--pigeon_6_in_hole_6]).

input_clause(hole_6_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_6,--pigeon_7_in_hole_6]).

input_clause(hole_6_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_6,--pigeon_8_in_hole_6]).

input_clause(hole_6_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_6,--pigeon_9_in_hole_6]).

input_clause(hole_6_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_6,--pigeon_10_in_hole_6]).

input_clause(hole_6_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_6,--pigeon_11_in_hole_6]).

input_clause(hole_6_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_6_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_6,--pigeon_4_in_hole_6]).

input_clause(hole_6_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_6,--pigeon_5_in_hole_6]).

input_clause(hole_6_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_6,--pigeon_6_in_hole_6]).

input_clause(hole_6_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_6,--pigeon_7_in_hole_6]).

input_clause(hole_6_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_6,--pigeon_8_in_hole_6]).

input_clause(hole_6_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_6,--pigeon_9_in_hole_6]).

input_clause(hole_6_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_6,--pigeon_10_in_hole_6]).

input_clause(hole_6_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_6,--pigeon_11_in_hole_6]).

input_clause(hole_6_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_6_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_6,--pigeon_5_in_hole_6]).

input_clause(hole_6_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_6,--pigeon_6_in_hole_6]).

input_clause(hole_6_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_6,--pigeon_7_in_hole_6]).

input_clause(hole_6_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_6,--pigeon_8_in_hole_6]).

input_clause(hole_6_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_6,--pigeon_9_in_hole_6]).

input_clause(hole_6_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_6,--pigeon_10_in_hole_6]).

input_clause(hole_6_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_6,--pigeon_11_in_hole_6]).

input_clause(hole_6_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_6_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_6,--pigeon_6_in_hole_6]).

input_clause(hole_6_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_6,--pigeon_7_in_hole_6]).

input_clause(hole_6_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_6,--pigeon_8_in_hole_6]).

input_clause(hole_6_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_6,--pigeon_9_in_hole_6]).

input_clause(hole_6_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_6,--pigeon_10_in_hole_6]).

input_clause(hole_6_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_6,--pigeon_11_in_hole_6]).

input_clause(hole_6_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_6_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_6,--pigeon_7_in_hole_6]).

input_clause(hole_6_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_6,--pigeon_8_in_hole_6]).

input_clause(hole_6_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_6,--pigeon_9_in_hole_6]).

input_clause(hole_6_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_6,--pigeon_10_in_hole_6]).

input_clause(hole_6_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_6,--pigeon_11_in_hole_6]).

input_clause(hole_6_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_6_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_6,--pigeon_8_in_hole_6]).

input_clause(hole_6_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_6,--pigeon_9_in_hole_6]).

input_clause(hole_6_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_6,--pigeon_10_in_hole_6]).

input_clause(hole_6_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_6,--pigeon_11_in_hole_6]).

input_clause(hole_6_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_6_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_6,--pigeon_9_in_hole_6]).

input_clause(hole_6_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_6,--pigeon_10_in_hole_6]).

input_clause(hole_6_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_6,--pigeon_11_in_hole_6]).

input_clause(hole_6_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_6_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_6,--pigeon_10_in_hole_6]).

input_clause(hole_6_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_6,--pigeon_11_in_hole_6]).

input_clause(hole_6_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_6_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_6,--pigeon_11_in_hole_6]).

input_clause(hole_6_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_6_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_6,--pigeon_12_in_hole_6]).

input_clause(hole_7_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_7,--pigeon_2_in_hole_7]).

input_clause(hole_7_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_7,--pigeon_3_in_hole_7]).

input_clause(hole_7_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_7,--pigeon_4_in_hole_7]).

input_clause(hole_7_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_7,--pigeon_5_in_hole_7]).

input_clause(hole_7_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_7,--pigeon_6_in_hole_7]).

input_clause(hole_7_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_7,--pigeon_7_in_hole_7]).

input_clause(hole_7_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_7,--pigeon_8_in_hole_7]).

input_clause(hole_7_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_7,--pigeon_9_in_hole_7]).

input_clause(hole_7_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_7,--pigeon_10_in_hole_7]).

input_clause(hole_7_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_7,--pigeon_11_in_hole_7]).

input_clause(hole_7_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_7_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_7,--pigeon_3_in_hole_7]).

input_clause(hole_7_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_7,--pigeon_4_in_hole_7]).

input_clause(hole_7_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_7,--pigeon_5_in_hole_7]).

input_clause(hole_7_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_7,--pigeon_6_in_hole_7]).

input_clause(hole_7_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_7,--pigeon_7_in_hole_7]).

input_clause(hole_7_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_7,--pigeon_8_in_hole_7]).

input_clause(hole_7_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_7,--pigeon_9_in_hole_7]).

input_clause(hole_7_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_7,--pigeon_10_in_hole_7]).

input_clause(hole_7_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_7,--pigeon_11_in_hole_7]).

input_clause(hole_7_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_7_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_7,--pigeon_4_in_hole_7]).

input_clause(hole_7_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_7,--pigeon_5_in_hole_7]).

input_clause(hole_7_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_7,--pigeon_6_in_hole_7]).

input_clause(hole_7_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_7,--pigeon_7_in_hole_7]).

input_clause(hole_7_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_7,--pigeon_8_in_hole_7]).

input_clause(hole_7_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_7,--pigeon_9_in_hole_7]).

input_clause(hole_7_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_7,--pigeon_10_in_hole_7]).

input_clause(hole_7_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_7,--pigeon_11_in_hole_7]).

input_clause(hole_7_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_7_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_7,--pigeon_5_in_hole_7]).

input_clause(hole_7_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_7,--pigeon_6_in_hole_7]).

input_clause(hole_7_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_7,--pigeon_7_in_hole_7]).

input_clause(hole_7_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_7,--pigeon_8_in_hole_7]).

input_clause(hole_7_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_7,--pigeon_9_in_hole_7]).

input_clause(hole_7_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_7,--pigeon_10_in_hole_7]).

input_clause(hole_7_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_7,--pigeon_11_in_hole_7]).

input_clause(hole_7_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_7_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_7,--pigeon_6_in_hole_7]).

input_clause(hole_7_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_7,--pigeon_7_in_hole_7]).

input_clause(hole_7_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_7,--pigeon_8_in_hole_7]).

input_clause(hole_7_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_7,--pigeon_9_in_hole_7]).

input_clause(hole_7_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_7,--pigeon_10_in_hole_7]).

input_clause(hole_7_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_7,--pigeon_11_in_hole_7]).

input_clause(hole_7_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_7_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_7,--pigeon_7_in_hole_7]).

input_clause(hole_7_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_7,--pigeon_8_in_hole_7]).

input_clause(hole_7_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_7,--pigeon_9_in_hole_7]).

input_clause(hole_7_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_7,--pigeon_10_in_hole_7]).

input_clause(hole_7_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_7,--pigeon_11_in_hole_7]).

input_clause(hole_7_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_7_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_7,--pigeon_8_in_hole_7]).

input_clause(hole_7_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_7,--pigeon_9_in_hole_7]).

input_clause(hole_7_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_7,--pigeon_10_in_hole_7]).

input_clause(hole_7_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_7,--pigeon_11_in_hole_7]).

input_clause(hole_7_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_7_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_7,--pigeon_9_in_hole_7]).

input_clause(hole_7_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_7,--pigeon_10_in_hole_7]).

input_clause(hole_7_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_7,--pigeon_11_in_hole_7]).

input_clause(hole_7_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_7_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_7,--pigeon_10_in_hole_7]).

input_clause(hole_7_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_7,--pigeon_11_in_hole_7]).

input_clause(hole_7_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_7_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_7,--pigeon_11_in_hole_7]).

input_clause(hole_7_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_7_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_7,--pigeon_12_in_hole_7]).

input_clause(hole_8_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_8,--pigeon_2_in_hole_8]).

input_clause(hole_8_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_8,--pigeon_3_in_hole_8]).

input_clause(hole_8_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_8,--pigeon_4_in_hole_8]).

input_clause(hole_8_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_8,--pigeon_5_in_hole_8]).

input_clause(hole_8_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_8,--pigeon_6_in_hole_8]).

input_clause(hole_8_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_8,--pigeon_7_in_hole_8]).

input_clause(hole_8_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_8,--pigeon_8_in_hole_8]).

input_clause(hole_8_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_8,--pigeon_9_in_hole_8]).

input_clause(hole_8_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_8,--pigeon_10_in_hole_8]).

input_clause(hole_8_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_8,--pigeon_11_in_hole_8]).

input_clause(hole_8_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_8_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_8,--pigeon_3_in_hole_8]).

input_clause(hole_8_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_8,--pigeon_4_in_hole_8]).

input_clause(hole_8_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_8,--pigeon_5_in_hole_8]).

input_clause(hole_8_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_8,--pigeon_6_in_hole_8]).

input_clause(hole_8_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_8,--pigeon_7_in_hole_8]).

input_clause(hole_8_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_8,--pigeon_8_in_hole_8]).

input_clause(hole_8_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_8,--pigeon_9_in_hole_8]).

input_clause(hole_8_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_8,--pigeon_10_in_hole_8]).

input_clause(hole_8_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_8,--pigeon_11_in_hole_8]).

input_clause(hole_8_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_8_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_8,--pigeon_4_in_hole_8]).

input_clause(hole_8_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_8,--pigeon_5_in_hole_8]).

input_clause(hole_8_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_8,--pigeon_6_in_hole_8]).

input_clause(hole_8_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_8,--pigeon_7_in_hole_8]).

input_clause(hole_8_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_8,--pigeon_8_in_hole_8]).

input_clause(hole_8_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_8,--pigeon_9_in_hole_8]).

input_clause(hole_8_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_8,--pigeon_10_in_hole_8]).

input_clause(hole_8_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_8,--pigeon_11_in_hole_8]).

input_clause(hole_8_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_8_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_8,--pigeon_5_in_hole_8]).

input_clause(hole_8_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_8,--pigeon_6_in_hole_8]).

input_clause(hole_8_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_8,--pigeon_7_in_hole_8]).

input_clause(hole_8_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_8,--pigeon_8_in_hole_8]).

input_clause(hole_8_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_8,--pigeon_9_in_hole_8]).

input_clause(hole_8_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_8,--pigeon_10_in_hole_8]).

input_clause(hole_8_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_8,--pigeon_11_in_hole_8]).

input_clause(hole_8_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_8_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_8,--pigeon_6_in_hole_8]).

input_clause(hole_8_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_8,--pigeon_7_in_hole_8]).

input_clause(hole_8_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_8,--pigeon_8_in_hole_8]).

input_clause(hole_8_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_8,--pigeon_9_in_hole_8]).

input_clause(hole_8_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_8,--pigeon_10_in_hole_8]).

input_clause(hole_8_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_8,--pigeon_11_in_hole_8]).

input_clause(hole_8_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_8_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_8,--pigeon_7_in_hole_8]).

input_clause(hole_8_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_8,--pigeon_8_in_hole_8]).

input_clause(hole_8_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_8,--pigeon_9_in_hole_8]).

input_clause(hole_8_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_8,--pigeon_10_in_hole_8]).

input_clause(hole_8_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_8,--pigeon_11_in_hole_8]).

input_clause(hole_8_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_8_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_8,--pigeon_8_in_hole_8]).

input_clause(hole_8_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_8,--pigeon_9_in_hole_8]).

input_clause(hole_8_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_8,--pigeon_10_in_hole_8]).

input_clause(hole_8_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_8,--pigeon_11_in_hole_8]).

input_clause(hole_8_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_8_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_8,--pigeon_9_in_hole_8]).

input_clause(hole_8_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_8,--pigeon_10_in_hole_8]).

input_clause(hole_8_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_8,--pigeon_11_in_hole_8]).

input_clause(hole_8_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_8_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_8,--pigeon_10_in_hole_8]).

input_clause(hole_8_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_8,--pigeon_11_in_hole_8]).

input_clause(hole_8_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_8_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_8,--pigeon_11_in_hole_8]).

input_clause(hole_8_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_8_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_8,--pigeon_12_in_hole_8]).

input_clause(hole_9_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_9,--pigeon_2_in_hole_9]).

input_clause(hole_9_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_9,--pigeon_3_in_hole_9]).

input_clause(hole_9_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_9,--pigeon_4_in_hole_9]).

input_clause(hole_9_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_9,--pigeon_5_in_hole_9]).

input_clause(hole_9_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_9,--pigeon_6_in_hole_9]).

input_clause(hole_9_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_9,--pigeon_7_in_hole_9]).

input_clause(hole_9_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_9,--pigeon_8_in_hole_9]).

input_clause(hole_9_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_9,--pigeon_9_in_hole_9]).

input_clause(hole_9_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_9,--pigeon_10_in_hole_9]).

input_clause(hole_9_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_9,--pigeon_11_in_hole_9]).

input_clause(hole_9_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_9_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_9,--pigeon_3_in_hole_9]).

input_clause(hole_9_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_9,--pigeon_4_in_hole_9]).

input_clause(hole_9_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_9,--pigeon_5_in_hole_9]).

input_clause(hole_9_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_9,--pigeon_6_in_hole_9]).

input_clause(hole_9_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_9,--pigeon_7_in_hole_9]).

input_clause(hole_9_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_9,--pigeon_8_in_hole_9]).

input_clause(hole_9_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_9,--pigeon_9_in_hole_9]).

input_clause(hole_9_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_9,--pigeon_10_in_hole_9]).

input_clause(hole_9_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_9,--pigeon_11_in_hole_9]).

input_clause(hole_9_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_9_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_9,--pigeon_4_in_hole_9]).

input_clause(hole_9_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_9,--pigeon_5_in_hole_9]).

input_clause(hole_9_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_9,--pigeon_6_in_hole_9]).

input_clause(hole_9_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_9,--pigeon_7_in_hole_9]).

input_clause(hole_9_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_9,--pigeon_8_in_hole_9]).

input_clause(hole_9_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_9,--pigeon_9_in_hole_9]).

input_clause(hole_9_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_9,--pigeon_10_in_hole_9]).

input_clause(hole_9_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_9,--pigeon_11_in_hole_9]).

input_clause(hole_9_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_9_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_9,--pigeon_5_in_hole_9]).

input_clause(hole_9_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_9,--pigeon_6_in_hole_9]).

input_clause(hole_9_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_9,--pigeon_7_in_hole_9]).

input_clause(hole_9_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_9,--pigeon_8_in_hole_9]).

input_clause(hole_9_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_9,--pigeon_9_in_hole_9]).

input_clause(hole_9_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_9,--pigeon_10_in_hole_9]).

input_clause(hole_9_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_9,--pigeon_11_in_hole_9]).

input_clause(hole_9_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_9_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_9,--pigeon_6_in_hole_9]).

input_clause(hole_9_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_9,--pigeon_7_in_hole_9]).

input_clause(hole_9_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_9,--pigeon_8_in_hole_9]).

input_clause(hole_9_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_9,--pigeon_9_in_hole_9]).

input_clause(hole_9_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_9,--pigeon_10_in_hole_9]).

input_clause(hole_9_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_9,--pigeon_11_in_hole_9]).

input_clause(hole_9_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_9_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_9,--pigeon_7_in_hole_9]).

input_clause(hole_9_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_9,--pigeon_8_in_hole_9]).

input_clause(hole_9_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_9,--pigeon_9_in_hole_9]).

input_clause(hole_9_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_9,--pigeon_10_in_hole_9]).

input_clause(hole_9_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_9,--pigeon_11_in_hole_9]).

input_clause(hole_9_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_9_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_9,--pigeon_8_in_hole_9]).

input_clause(hole_9_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_9,--pigeon_9_in_hole_9]).

input_clause(hole_9_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_9,--pigeon_10_in_hole_9]).

input_clause(hole_9_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_9,--pigeon_11_in_hole_9]).

input_clause(hole_9_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_9_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_9,--pigeon_9_in_hole_9]).

input_clause(hole_9_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_9,--pigeon_10_in_hole_9]).

input_clause(hole_9_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_9,--pigeon_11_in_hole_9]).

input_clause(hole_9_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_9_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_9,--pigeon_10_in_hole_9]).

input_clause(hole_9_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_9,--pigeon_11_in_hole_9]).

input_clause(hole_9_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_9_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_9,--pigeon_11_in_hole_9]).

input_clause(hole_9_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_9_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_9,--pigeon_12_in_hole_9]).

input_clause(hole_10_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_10,--pigeon_2_in_hole_10]).

input_clause(hole_10_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_10,--pigeon_3_in_hole_10]).

input_clause(hole_10_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_10,--pigeon_4_in_hole_10]).

input_clause(hole_10_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_10,--pigeon_5_in_hole_10]).

input_clause(hole_10_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_10,--pigeon_6_in_hole_10]).

input_clause(hole_10_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_10,--pigeon_7_in_hole_10]).

input_clause(hole_10_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_10,--pigeon_8_in_hole_10]).

input_clause(hole_10_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_10,--pigeon_9_in_hole_10]).

input_clause(hole_10_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_10,--pigeon_10_in_hole_10]).

input_clause(hole_10_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_10,--pigeon_11_in_hole_10]).

input_clause(hole_10_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_10_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_10,--pigeon_3_in_hole_10]).

input_clause(hole_10_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_10,--pigeon_4_in_hole_10]).

input_clause(hole_10_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_10,--pigeon_5_in_hole_10]).

input_clause(hole_10_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_10,--pigeon_6_in_hole_10]).

input_clause(hole_10_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_10,--pigeon_7_in_hole_10]).

input_clause(hole_10_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_10,--pigeon_8_in_hole_10]).

input_clause(hole_10_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_10,--pigeon_9_in_hole_10]).

input_clause(hole_10_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_10,--pigeon_10_in_hole_10]).

input_clause(hole_10_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_10,--pigeon_11_in_hole_10]).

input_clause(hole_10_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_10_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_10,--pigeon_4_in_hole_10]).

input_clause(hole_10_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_10,--pigeon_5_in_hole_10]).

input_clause(hole_10_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_10,--pigeon_6_in_hole_10]).

input_clause(hole_10_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_10,--pigeon_7_in_hole_10]).

input_clause(hole_10_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_10,--pigeon_8_in_hole_10]).

input_clause(hole_10_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_10,--pigeon_9_in_hole_10]).

input_clause(hole_10_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_10,--pigeon_10_in_hole_10]).

input_clause(hole_10_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_10,--pigeon_11_in_hole_10]).

input_clause(hole_10_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_10_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_10,--pigeon_5_in_hole_10]).

input_clause(hole_10_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_10,--pigeon_6_in_hole_10]).

input_clause(hole_10_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_10,--pigeon_7_in_hole_10]).

input_clause(hole_10_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_10,--pigeon_8_in_hole_10]).

input_clause(hole_10_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_10,--pigeon_9_in_hole_10]).

input_clause(hole_10_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_10,--pigeon_10_in_hole_10]).

input_clause(hole_10_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_10,--pigeon_11_in_hole_10]).

input_clause(hole_10_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_10_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_10,--pigeon_6_in_hole_10]).

input_clause(hole_10_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_10,--pigeon_7_in_hole_10]).

input_clause(hole_10_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_10,--pigeon_8_in_hole_10]).

input_clause(hole_10_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_10,--pigeon_9_in_hole_10]).

input_clause(hole_10_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_10,--pigeon_10_in_hole_10]).

input_clause(hole_10_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_10,--pigeon_11_in_hole_10]).

input_clause(hole_10_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_10_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_10,--pigeon_7_in_hole_10]).

input_clause(hole_10_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_10,--pigeon_8_in_hole_10]).

input_clause(hole_10_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_10,--pigeon_9_in_hole_10]).

input_clause(hole_10_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_10,--pigeon_10_in_hole_10]).

input_clause(hole_10_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_10,--pigeon_11_in_hole_10]).

input_clause(hole_10_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_10_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_10,--pigeon_8_in_hole_10]).

input_clause(hole_10_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_10,--pigeon_9_in_hole_10]).

input_clause(hole_10_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_10,--pigeon_10_in_hole_10]).

input_clause(hole_10_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_10,--pigeon_11_in_hole_10]).

input_clause(hole_10_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_10_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_10,--pigeon_9_in_hole_10]).

input_clause(hole_10_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_10,--pigeon_10_in_hole_10]).

input_clause(hole_10_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_10,--pigeon_11_in_hole_10]).

input_clause(hole_10_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_10_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_10,--pigeon_10_in_hole_10]).

input_clause(hole_10_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_10,--pigeon_11_in_hole_10]).

input_clause(hole_10_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_10_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_10,--pigeon_11_in_hole_10]).

input_clause(hole_10_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_10_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_10,--pigeon_12_in_hole_10]).

input_clause(hole_11_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_11,--pigeon_2_in_hole_11]).

input_clause(hole_11_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_11,--pigeon_3_in_hole_11]).

input_clause(hole_11_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_11,--pigeon_4_in_hole_11]).

input_clause(hole_11_pigeons_1_and_5,theorem,
    [--pigeon_1_in_hole_11,--pigeon_5_in_hole_11]).

input_clause(hole_11_pigeons_1_and_6,theorem,
    [--pigeon_1_in_hole_11,--pigeon_6_in_hole_11]).

input_clause(hole_11_pigeons_1_and_7,theorem,
    [--pigeon_1_in_hole_11,--pigeon_7_in_hole_11]).

input_clause(hole_11_pigeons_1_and_8,theorem,
    [--pigeon_1_in_hole_11,--pigeon_8_in_hole_11]).

input_clause(hole_11_pigeons_1_and_9,theorem,
    [--pigeon_1_in_hole_11,--pigeon_9_in_hole_11]).

input_clause(hole_11_pigeons_1_and_10,theorem,
    [--pigeon_1_in_hole_11,--pigeon_10_in_hole_11]).

input_clause(hole_11_pigeons_1_and_11,theorem,
    [--pigeon_1_in_hole_11,--pigeon_11_in_hole_11]).

input_clause(hole_11_pigeons_1_and_12,theorem,
    [--pigeon_1_in_hole_11,--pigeon_12_in_hole_11]).

input_clause(hole_11_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_11,--pigeon_3_in_hole_11]).

input_clause(hole_11_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_11,--pigeon_4_in_hole_11]).

input_clause(hole_11_pigeons_2_and_5,theorem,
    [--pigeon_2_in_hole_11,--pigeon_5_in_hole_11]).

input_clause(hole_11_pigeons_2_and_6,theorem,
    [--pigeon_2_in_hole_11,--pigeon_6_in_hole_11]).

input_clause(hole_11_pigeons_2_and_7,theorem,
    [--pigeon_2_in_hole_11,--pigeon_7_in_hole_11]).

input_clause(hole_11_pigeons_2_and_8,theorem,
    [--pigeon_2_in_hole_11,--pigeon_8_in_hole_11]).

input_clause(hole_11_pigeons_2_and_9,theorem,
    [--pigeon_2_in_hole_11,--pigeon_9_in_hole_11]).

input_clause(hole_11_pigeons_2_and_10,theorem,
    [--pigeon_2_in_hole_11,--pigeon_10_in_hole_11]).

input_clause(hole_11_pigeons_2_and_11,theorem,
    [--pigeon_2_in_hole_11,--pigeon_11_in_hole_11]).

input_clause(hole_11_pigeons_2_and_12,theorem,
    [--pigeon_2_in_hole_11,--pigeon_12_in_hole_11]).

input_clause(hole_11_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_11,--pigeon_4_in_hole_11]).

input_clause(hole_11_pigeons_3_and_5,theorem,
    [--pigeon_3_in_hole_11,--pigeon_5_in_hole_11]).

input_clause(hole_11_pigeons_3_and_6,theorem,
    [--pigeon_3_in_hole_11,--pigeon_6_in_hole_11]).

input_clause(hole_11_pigeons_3_and_7,theorem,
    [--pigeon_3_in_hole_11,--pigeon_7_in_hole_11]).

input_clause(hole_11_pigeons_3_and_8,theorem,
    [--pigeon_3_in_hole_11,--pigeon_8_in_hole_11]).

input_clause(hole_11_pigeons_3_and_9,theorem,
    [--pigeon_3_in_hole_11,--pigeon_9_in_hole_11]).

input_clause(hole_11_pigeons_3_and_10,theorem,
    [--pigeon_3_in_hole_11,--pigeon_10_in_hole_11]).

input_clause(hole_11_pigeons_3_and_11,theorem,
    [--pigeon_3_in_hole_11,--pigeon_11_in_hole_11]).

input_clause(hole_11_pigeons_3_and_12,theorem,
    [--pigeon_3_in_hole_11,--pigeon_12_in_hole_11]).

input_clause(hole_11_pigeons_4_and_5,theorem,
    [--pigeon_4_in_hole_11,--pigeon_5_in_hole_11]).

input_clause(hole_11_pigeons_4_and_6,theorem,
    [--pigeon_4_in_hole_11,--pigeon_6_in_hole_11]).

input_clause(hole_11_pigeons_4_and_7,theorem,
    [--pigeon_4_in_hole_11,--pigeon_7_in_hole_11]).

input_clause(hole_11_pigeons_4_and_8,theorem,
    [--pigeon_4_in_hole_11,--pigeon_8_in_hole_11]).

input_clause(hole_11_pigeons_4_and_9,theorem,
    [--pigeon_4_in_hole_11,--pigeon_9_in_hole_11]).

input_clause(hole_11_pigeons_4_and_10,theorem,
    [--pigeon_4_in_hole_11,--pigeon_10_in_hole_11]).

input_clause(hole_11_pigeons_4_and_11,theorem,
    [--pigeon_4_in_hole_11,--pigeon_11_in_hole_11]).

input_clause(hole_11_pigeons_4_and_12,theorem,
    [--pigeon_4_in_hole_11,--pigeon_12_in_hole_11]).

input_clause(hole_11_pigeons_5_and_6,theorem,
    [--pigeon_5_in_hole_11,--pigeon_6_in_hole_11]).

input_clause(hole_11_pigeons_5_and_7,theorem,
    [--pigeon_5_in_hole_11,--pigeon_7_in_hole_11]).

input_clause(hole_11_pigeons_5_and_8,theorem,
    [--pigeon_5_in_hole_11,--pigeon_8_in_hole_11]).

input_clause(hole_11_pigeons_5_and_9,theorem,
    [--pigeon_5_in_hole_11,--pigeon_9_in_hole_11]).

input_clause(hole_11_pigeons_5_and_10,theorem,
    [--pigeon_5_in_hole_11,--pigeon_10_in_hole_11]).

input_clause(hole_11_pigeons_5_and_11,theorem,
    [--pigeon_5_in_hole_11,--pigeon_11_in_hole_11]).

input_clause(hole_11_pigeons_5_and_12,theorem,
    [--pigeon_5_in_hole_11,--pigeon_12_in_hole_11]).

input_clause(hole_11_pigeons_6_and_7,theorem,
    [--pigeon_6_in_hole_11,--pigeon_7_in_hole_11]).

input_clause(hole_11_pigeons_6_and_8,theorem,
    [--pigeon_6_in_hole_11,--pigeon_8_in_hole_11]).

input_clause(hole_11_pigeons_6_and_9,theorem,
    [--pigeon_6_in_hole_11,--pigeon_9_in_hole_11]).

input_clause(hole_11_pigeons_6_and_10,theorem,
    [--pigeon_6_in_hole_11,--pigeon_10_in_hole_11]).

input_clause(hole_11_pigeons_6_and_11,theorem,
    [--pigeon_6_in_hole_11,--pigeon_11_in_hole_11]).

input_clause(hole_11_pigeons_6_and_12,theorem,
    [--pigeon_6_in_hole_11,--pigeon_12_in_hole_11]).

input_clause(hole_11_pigeons_7_and_8,theorem,
    [--pigeon_7_in_hole_11,--pigeon_8_in_hole_11]).

input_clause(hole_11_pigeons_7_and_9,theorem,
    [--pigeon_7_in_hole_11,--pigeon_9_in_hole_11]).

input_clause(hole_11_pigeons_7_and_10,theorem,
    [--pigeon_7_in_hole_11,--pigeon_10_in_hole_11]).

input_clause(hole_11_pigeons_7_and_11,theorem,
    [--pigeon_7_in_hole_11,--pigeon_11_in_hole_11]).

input_clause(hole_11_pigeons_7_and_12,theorem,
    [--pigeon_7_in_hole_11,--pigeon_12_in_hole_11]).

input_clause(hole_11_pigeons_8_and_9,theorem,
    [--pigeon_8_in_hole_11,--pigeon_9_in_hole_11]).

input_clause(hole_11_pigeons_8_and_10,theorem,
    [--pigeon_8_in_hole_11,--pigeon_10_in_hole_11]).

input_clause(hole_11_pigeons_8_and_11,theorem,
    [--pigeon_8_in_hole_11,--pigeon_11_in_hole_11]).

input_clause(hole_11_pigeons_8_and_12,theorem,
    [--pigeon_8_in_hole_11,--pigeon_12_in_hole_11]).

input_clause(hole_11_pigeons_9_and_10,theorem,
    [--pigeon_9_in_hole_11,--pigeon_10_in_hole_11]).

input_clause(hole_11_pigeons_9_and_11,theorem,
    [--pigeon_9_in_hole_11,--pigeon_11_in_hole_11]).

input_clause(hole_11_pigeons_9_and_12,theorem,
    [--pigeon_9_in_hole_11,--pigeon_12_in_hole_11]).

input_clause(hole_11_pigeons_10_and_11,theorem,
    [--pigeon_10_in_hole_11,--pigeon_11_in_hole_11]).

input_clause(hole_11_pigeons_10_and_12,theorem,
    [--pigeon_10_in_hole_11,--pigeon_12_in_hole_11]).

input_clause(hole_11_pigeons_11_and_12,theorem,
    [--pigeon_11_in_hole_11,--pigeon_12_in_hole_11]).
%--------------------------------------------------------------------------
