%--------------------------------------------------------------------------
% File     : MSC007=Pigeon-1.004 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : Cook pigeon-hole problem
% Version  : Theorem formulation : Propositional; 4 pigeons.
% English  : Suppose there are N holes and N+1 pigeons to put in the 
%            holes. Every pigeon is in a hole and no hole contains more 
%            than one pigeon. Prove that this is impossible.

% Refs     : Cook S. and Reckhow R. (1979), The Relative Efficiency 
%            of Propositional Proof Systems, Journal of Symbolic Logic 44, 
%            36-50.
%          : Pelletier F.J. (1986), Seventy-Five Problems for Testing 
%            Automatic Theorem Provers, Journal of Automated Reasoning 
%            2(2), 191-216.
% Source   : [Pelletier, 1986]
% Names    : Pelletier 72 [Pelletier, 1986]
%          : pigeon.in [OTTER]

% Status   : 
% Syntax   : Number of clauses           :   22 (   4 non-Horn)(   0 unit)
%            Number of literals          :   48 (   0 equality)
%            Number of predicate symbols :   12 (  12 propositional)
%            Number of function symbols  :    0 (   0 constant)
%            Number of variables         :    0 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    0

% Comments : For an N hole problem, the number of propositions 
%            is N^2 + N and the number of clauses is (N^3 + N^2)/2 + N+1. 
%            Thus the number of propositions increases quadratically and 
%            the number of clauses increases cubically.
%--------------------------------------------------------------------------
input_clause(pigeon_1,theorem,
    [++pigeon_1_in_hole_1,++pigeon_1_in_hole_2,++pigeon_1_in_hole_3]).

input_clause(pigeon_2,theorem,
    [++pigeon_2_in_hole_1,++pigeon_2_in_hole_2,++pigeon_2_in_hole_3]).

input_clause(pigeon_3,theorem,
    [++pigeon_3_in_hole_1,++pigeon_3_in_hole_2,++pigeon_3_in_hole_3]).

input_clause(pigeon_4,theorem,
    [++pigeon_4_in_hole_1,++pigeon_4_in_hole_2,++pigeon_4_in_hole_3]).

input_clause(hole_1_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_1,--pigeon_2_in_hole_1]).

input_clause(hole_1_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_1,--pigeon_3_in_hole_1]).

input_clause(hole_1_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_1,--pigeon_4_in_hole_1]).

input_clause(hole_1_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_1,--pigeon_3_in_hole_1]).

input_clause(hole_1_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_1,--pigeon_4_in_hole_1]).

input_clause(hole_1_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_1,--pigeon_4_in_hole_1]).

input_clause(hole_2_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_2,--pigeon_2_in_hole_2]).

input_clause(hole_2_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_2,--pigeon_3_in_hole_2]).

input_clause(hole_2_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_2,--pigeon_4_in_hole_2]).

input_clause(hole_2_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_2,--pigeon_3_in_hole_2]).

input_clause(hole_2_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_2,--pigeon_4_in_hole_2]).

input_clause(hole_2_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_2,--pigeon_4_in_hole_2]).

input_clause(hole_3_pigeons_1_and_2,theorem,
    [--pigeon_1_in_hole_3,--pigeon_2_in_hole_3]).

input_clause(hole_3_pigeons_1_and_3,theorem,
    [--pigeon_1_in_hole_3,--pigeon_3_in_hole_3]).

input_clause(hole_3_pigeons_1_and_4,theorem,
    [--pigeon_1_in_hole_3,--pigeon_4_in_hole_3]).

input_clause(hole_3_pigeons_2_and_3,theorem,
    [--pigeon_2_in_hole_3,--pigeon_3_in_hole_3]).

input_clause(hole_3_pigeons_2_and_4,theorem,
    [--pigeon_2_in_hole_3,--pigeon_4_in_hole_3]).

input_clause(hole_3_pigeons_3_and_4,theorem,
    [--pigeon_3_in_hole_3,--pigeon_4_in_hole_3]).
%--------------------------------------------------------------------------
