%--------------------------------------------------------------------------
% File     : MSC006=NonObv-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : A "non-obvious" problem
% Version  : 
% English  : Suppose there are two relations, P and Q. P is transitive, 
%            and Q is both transitive and symmetric.
%            Suppose further the "squareness" of P and Q: any two things 
%            are related either in the P manner or the Q manner. Prove 
%            that either P is total or Q is total.

% Refs     : Pelletier F.J., and Rudnicki P. (1986), Non-Obviousness, 
%            In Wos L. (Ed.), Association for Automated Reasoning 
%            Newsletter (6), Association for Automated Reasoning, Argonne, 
%            Il, 4-5.
% Source   : [Pelletier & Rudnicki, 1986]
% Names    : nonob.lop [SETHEO]

% Status   : 
% Syntax   : Number of clauses           :    6 (   1 non-Horn)(   2 unit)
%            Number of literals          :   12 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    4 (   4 constant)
%            Number of variables         :   10 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    1

% Comments : Rudnicki says "I think that what you call the non-obvious 
%            problem from our write-up with Jeff should be attributed 
%            to J. \Lo\'{s} (in LaTeX)." and "J. \Lo\'{s}  is in LaTeX, 
%            and it is the name of my Polish prof that told me that. 
%            English approximation of his name can be typed as J. Los.".
%--------------------------------------------------------------------------
input_clause(p_transitivity,hypothesis,
    [--p(X,Y),
     --p(Y,Z),
     ++p(X,Z)]).

input_clause(q_transitivity,hypothesis,
    [--q(X,Y),
     --q(Y,Z),
     ++q(X,Z)]).

input_clause(q_symmetry,hypothesis,
    [--q(X,Y),
     ++q(Y,X)]).

input_clause(all_related,hypothesis,
    [++p(X,Y),
     ++q(X,Y)]).

input_clause(p_is_not_total,hypothesis,
    [--p(a,b)]).

input_clause(prove_q_is_total,theorem,
    [--q(c,d)]).
%--------------------------------------------------------------------------
