%--------------------------------------------------------------------------
% File     : MSC005=XOR-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : The evaluation of XOR expressions
% Version  : 
% English  : 

% Refs     : Plaisted D.A. (1982), A Simplified Problem Reduction Format, 
%            Artificial Intelligence 18(X), 227-261.
% Source   : [Plaisted, 1982]
% Names    : Problem 5.1 [Plaisted, 1982]

% Status   : 
% Syntax   : Number of clauses           :    7 (   0 non-Horn)(   3 unit)
%            Number of literals          :   15 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    3 (   2 constant)
%            Number of variables         :    9 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
input_clause(true_is_true,axiom,
    [++value(truth,truth)]).

input_clause(false_is_false,axiom,
    [++value(falsity,falsity)]).

input_clause(true_xor_true,axiom,
    [--value(X,truth),
     --value(Y,truth),
     ++value(xor(X,Y),falsity)]).

input_clause(true_xor_false,axiom,
    [--value(X,truth),
     --value(Y,falsity),
     ++value(xor(X,Y),truth)]).

input_clause(false_xor_true,axiom,
    [--value(X,falsity),
     --value(Y,truth),
     ++value(xor(X,Y),truth)]).

input_clause(false_xor_false,axiom,
    [--value(X,falsity),
     --value(Y,falsity),
     ++value(xor(X,Y),falsity)]).

input_clause(evaluate_expression,theorem,
    [--value(xor(xor(xor(xor(truth,falsity),falsity),truth),falsity),
Value)]).
%--------------------------------------------------------------------------
