%--------------------------------------------------------------------------
% File     : MSC004=HasParts2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : Show that the boy, John, has 10 fingers
% Version  : 
% English  : 

% Refs     : Reboh R,. Raphael B., Yates R.A., Kling R.E. and 
%            Verlarde C. (1972), Stuidy of Automatic Theorem-Proving 
%            Programs, Technical Note 72, Artificial Intelligence Centre 
%            SRI International, Menlo Park, CA.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : HASPARTS-T2 [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :    8 (   1 non-Horn)(   2 unit)
%            Number of literals          :   16 (   0 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   11 (   9 constant)
%            Number of variables         :   14 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
input_clause(not_part_inheritance,axiom,
    [++in(object_in(Big_part,Mid_part,Small_part,Number_of_mid_parts,
Number_of_small_parts),Mid_part),
     ++has_parts(Big_part,times(Number_of_mid_parts,
Number_of_small_parts),Small_part),
     --has_parts(Big_part,Number_of_mid_parts,Mid_part)]).

input_clause(part_inheritance,axiom,
    [++has_parts(Big_part,times(Number_of_mid_parts,
Number_of_small_parts),Small_part),
     --has_parts(Big_part,Number_of_mid_parts,Mid_part),
     --has_parts(object_in(Big_part,Mid_part,Small_part,
Number_of_mid_parts,Number_of_small_parts),Number_of_small_parts,
Small_part)]).

input_clause(john_is_a_boy,hypothesis,
    [++in(john, boy)]).

input_clause(in_boy_in_human,hypothesis,
    [++in(X,human),
     --in(X,boy)]).

input_clause(hands_have_5_fingers,hypothesis,
    [++has_parts(X, 5, fingers),
     --in(X, hand)]).

input_clause(humans_have_two_arms,hypothesis,
    [++has_parts(X, 2, arm),
     --in(X, human)]).

input_clause(arms_have_one_hand,hypothesis,
    [++has_parts(X,1,hand),
     --in(X,arm)]).

input_clause(prove_john_has_10_fingers,theorem,
    [--has_parts(john,times(times(2,1),5),fingers)]).
%--------------------------------------------------------------------------
