%--------------------------------------------------------------------------
% File     : MSC002=BHand2-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : A Blind Hand Problem
% Version  : Theorem formulation : Reduced > Complete.
% English  : 

% Refs     : Popplestone R.J. (1970), Freddy, things and sets, 
%            (unpublished).
%          : Michie D., Ross R. and Shannan G.J. (1972), G-deduction, 
%            Machine Intelligence 7, Edinburgh University Press, 141-165.
% Source   : [TPTP]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   10 (   1 non-Horn)(   3 unit)
%            Number of literals          :   20 (   0 equality)
%            Number of predicate symbols :    6 (   0 propositional)
%            Number of function symbols  :    7 (   4 constant)
%            Number of variables         :   24 (   6 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(something_is_here_now,hypothesis,
    [++at(something,here,now)]).

input_clause(cant_hold_and_let_go,hypothesis,
    [--hold(Thing,let_go(Situation))]).

input_clause(everything_is_red,hypothesis,
    [--at(Thing,here,Situation),
     ++red(Thing)]).

input_clause(situation_let_go,hypothesis,
    [--at(Thing,Place,Situation),
     ++at(Thing,Place,let_go(Situation))]).

input_clause(situation_pick_up,hypothesis,
    [--at(Thing,Place,Situation),
     ++at(Thing,Place,pick_up(Situation))]).

input_clause(can_grab_if_previously_let_go,hypothesis,
    [--at(Thing,Place,Situation),
     ++grab(Thing,pick_up(go(Place,let_go(Situation))))]).

input_clause(answer_if_red_and_put_there,hypothesis,
    [--red(Thing),
     --put(Thing,there,Situation),
     ++answer(Situation)]).

input_clause(can_put_somewhere_if_grab_and_go_there,hypothesis,
    [--at(Thing,Place,Situation),
     --grab(Thing,Situation),
     ++put(Thing,Another_place,go(Another_place,Situation))]).

input_clause(thing_either_held_or_went_there,hypothesis,
    [++hold(Thing,Situation),
     --at(Thing,Place,Situation),
     ++at(Thing,Place,go(Another_place,Situation))]).

input_clause(prove_there_is_an_answer_situation,theorem,
    [--answer(Situation)]).
%--------------------------------------------------------------------------
