%--------------------------------------------------------------------------
% File     : MSC001=BHand1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Miscellaneous
% Problem  : A Blind Hand Problem
% Version  : 
% English  : 

% Refs     : Popplestone R.J. (1970), Freddy, things and sets, 
%            (unpublished).
%          : Michie D., Ross R. and Shannan G.J. (1972), G-deduction, 
%            Machine Intelligence 7, Edinburgh University Press, 141-165.
%          : Wilson G.A. and Minker J. (1976), Resolution, Refinements, 
%            and Search Strategies: A Comparative Study, IEEE Transactions 
%            on Computers C-25(8), 782-801.
% Source   : [SPRFN]
% Names    : APABHP [Michie, et al., 1972]
%          : APABHP [Wilson & Minker, 1976]

% Status   : 
% Syntax   : Number of clauses           :   18 (   1 non-Horn)(   5 unit)
%            Number of literals          :   36 (   0 equality)
%            Number of predicate symbols :    4 (   0 propositional)
%            Number of function symbols  :   11 (   7 constant)
%            Number of variables         :   39 (   6 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : The clauses are in the original order except that the query 
%            has been put last.
%          : The symbols are explained in [Michie, Ross & Shannan, 1972].
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [--at(A,there,B),
     --at(A,here,B)]).

input_clause(clause_2,axiom,
    [--hold(thing(A),do(let_go,B))]).

input_clause(clause_3,axiom,
    [--red(hand)]).

input_clause(clause_5,axiom,
    [++at(hand,A,do(go(A),B))]).

input_clause(clause_6,axiom,
    [++at(thing(s),here,now)]).

input_clause(clause_7,axiom,
    [--at(thing(A),B,do(go(B),C)),
     ++at(thing(A),B,C),
     ++hold(thing(A),C)]).

input_clause(clause_8,axiom,
    [--at(hand,A,B),
     --at(thing(C),A,B),
     ++hold(thing(taken(B)),do(pick_up,B))]).

input_clause(clause_9,axiom,
    [--hold(thing(A),B),
     --at(hand,C,B),
     ++at(thing(A),C,B)]).

input_clause(clause_10,axiom,
    [--hold(thing(A),B),
     --at(thing(A),C,B),
     ++at(hand,C,B)]).

input_clause(clause_11,axiom,
    [--red(A),
     --at(A,there,B),
     ++answer(B)]).

input_clause(clause_12,axiom,
    [--at(thing(A),B,C),
     ++at(thing(A),B,do(go(B),C))]).

input_clause(clause_13,axiom,
    [--hold(thing(A),B),
     ++hold(thing(A),do(go(C),B))]).

input_clause(clause_14,axiom,
    [--at(hand,A,B),
     ++at(thing(taken(B)),A,B)]).

input_clause(clause_15,axiom,
    [--at(A,B,C),
     ++at(A,B,do(pick_up,C))]).

input_clause(clause_16,axiom,
    [--at(A,B,C),
     ++at(A,B,do(let_go,C))]).

input_clause(clause_17,axiom,
    [--at(A,B,do(let_go,C)),
     ++at(A,B,C)]).

input_clause(things_here_now_are_red,hypothesis,
    [--at(A,here,now),
     ++red(A)]).

input_clause(prove_there_is_a_red_thing,theorem,
    [--answer(A)]).
%--------------------------------------------------------------------------
