%--------------------------------------------------------------------------
% File     : LDA014=EmbdgAlgEqn9Indn-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras (Embedding algebras)
% Problem  : Let g = cr(t). Show that aag <= ag, t=a
% Version  : [Jech, 1993] axioms : Incomplete.
% English  : This is the induction step of an induction proof.

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : Conjecture 1 [Jech, 1993]

% Status   : open
% Syntax   : Number of clauses           :   33 (   2 non-Horn)(  21 unit)
%            Number of literals          :   50 (  32 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   19 (  17 constant)
%            Number of variables         :   38 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Embedding algebra axioms 
include('Axioms/LDA001-0.ax').
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [++equal(k,critical_point(a))]).

input_clause(clause_2,axiom,
    [++equal(aa,f(a,a))]).

input_clause(clause_3,axiom,
    [++equal(aak,f(aa,k))]).

input_clause(clause_4,axiom,
    [++equal(ak,f(a,k))]).

input_clause(clause_5,axiom,
    [++equal(crit_u,critical_point(u))]).

input_clause(clause_6,axiom,
    [++equal(aacrit_u,f(aa,crit_u))]).

input_clause(clause_7,axiom,
    [++equal(acrit_u,f(a,crit_u))]).

input_clause(clause_8,axiom,
    [++equal(crit_v,critical_point(v))]).

input_clause(clause_9,axiom,
    [++equal(aacrit_v,f(aa,crit_v))]).

input_clause(clause_10,axiom,
    [++equal(acrit_v,f(a,crit_v))]).

input_clause(clause_11,axiom,
    [++equal(uv,f(u,v))]).

input_clause(clause_12,axiom,
    [++equal(crit_uv,critical_point(uv))]).

input_clause(clause_13,axiom,
    [++equal(aacrit_uv,f(aa,crit_uv))]).

input_clause(clause_14,axiom,
    [++equal(acrit_uv,f(a,crit_uv))]).

%----Assume true for u and v 
input_clause(true_for_u,hypothesis,
    [--less(acrit_u,aacrit_u)]).

input_clause(true_for_v,hypothesis,
    [--less(acrit_v,aacrit_v)]).

%----Prove for u*v 
input_clause(prove_equation,theorem,
    [++less(acrit_uv,aacrit_uv)]).
%--------------------------------------------------------------------------
