%--------------------------------------------------------------------------
% File     : LDA013=EmbdgAlgEqn9Base-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras (Embedding algebras)
% Problem  : Let g = cr(t). Show that aag <= ag, t=a
% Version  : [Jech, 1993] axioms : Incomplete.
% English  : This is the base step of an induction proof.

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : Conjecture 1 [Jech, 1993]

% Status   : open
% Syntax   : Number of clauses           :   21 (   2 non-Horn)(   9 unit)
%            Number of literals          :   38 (  22 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   5 constant)
%            Number of variables         :   38 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Embedding algebra axioms 
include('Axioms/LDA001-0.ax').
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [++equal(k,critical_point(a))]).

input_clause(clause_2,axiom,
    [++equal(aa,f(a,a))]).

input_clause(clause_3,axiom,
    [++equal(aak,f(aa,k))]).

input_clause(clause_4,axiom,
    [++equal(ak,f(a,k))]).

%----aak <= ak 
input_clause(prove_equation,theorem,
    [++less(ak,aak)]).
%--------------------------------------------------------------------------
