%--------------------------------------------------------------------------
% File     : LDA012=EmbdgAlgEqn8-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras (Embedding algebras)
% Problem  : Let g = cr(t). Show that stts(sttt)g = g
% Version  : [Jech, 1993] axioms : Incomplete.
% English  : 

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : Problem 13 [Jech, 1993]

% Status   : 
% Syntax   : Number of clauses           :   28 (   2 non-Horn)(  16 unit)
%            Number of literals          :   45 (  29 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   14 (  12 constant)
%            Number of variables         :   38 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Embedding algebra axioms 
include('Axioms/LDA001-0.ax').
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [++equal(st,f(s,t))]).

input_clause(clause_2,axiom,
    [++equal(stt,f(st,t))]).

input_clause(clause_3,axiom,
    [++equal(sttt,f(stt,t))]).

input_clause(clause_4,axiom,
    [++equal(stts,f(stt,s))]).

input_clause(clause_5,axiom,
    [++equal(ts,f(t,s))]).

input_clause(clause_6,axiom,
    [++equal(sts,f(st,s))]).

input_clause(clause_7,axiom,
    [++equal(st_ts,f(st,ts))]).

input_clause(clause_8,axiom,
    [++equal(k,critical_point(t))]).

input_clause(clause_9,axiom,
    [++equal(sk,f(s,k))]).

input_clause(clause_10,axiom,
    [++equal(stk,f(st,k))]).

input_clause(clause_11,hypothesis,
    [++less(k,sk)]).

%----stts(sttt)k = k, where k=crit(t) < sk 
input_clause(prove_equation,theorem,
    [--equal(f(f(stts,sttt),k),k)]).
%--------------------------------------------------------------------------
