%--------------------------------------------------------------------------
% File     : LDA009=EmbdgAlgEqn5-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras (Embedding algebras)
% Problem  : Let g = cr(t). If g < sg, then st(ts)g < stt(sg)
% Version  : [Jech, 1993] axioms : Incomplete.
% English  : 

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : Problem 10 [Jech, 1993]

% Status   : 
% Syntax   : Number of clauses           :   28 (   2 non-Horn)(  16 unit)
%            Number of literals          :   45 (  28 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   14 (  12 constant)
%            Number of variables         :   38 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Embedding algebra axioms 
include('Axioms/LDA001-0.ax').
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [++equal(st,f(s,t))]).

input_clause(clause_2,axiom,
    [++equal(stt,f(st,t))]).

input_clause(clause_3,axiom,
    [++equal(sttt,f(stt,t))]).

input_clause(clause_4,axiom,
    [++equal(stts,f(stt,s))]).

input_clause(clause_5,axiom,
    [++equal(ts,f(t,s))]).

input_clause(clause_6,axiom,
    [++equal(sts,f(st,s))]).

input_clause(clause_7,axiom,
    [++equal(st_ts,f(st,ts))]).

input_clause(clause_8,axiom,
    [++equal(k,critical_point(t))]).

input_clause(clause_9,axiom,
    [++equal(sk,f(s,k))]).

input_clause(clause_10,axiom,
    [++equal(stk,f(st,k))]).

input_clause(clause_11,hypothesis,
    [++less(k,sk)]).

%----st(ts)k < stt(sk)   if crit(t)=k < sk 
input_clause(prove_equation,theorem,
    [--less(f(st_ts,k),f(stt,sk))]).
%--------------------------------------------------------------------------
