%--------------------------------------------------------------------------
% File     : LDA008=EmbdgAlgEqn4-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras (Embedding algebras)
% Problem  : Let g = cr(t) = cr(T). If Ta < Tsg, then ta < tsg
% Version  : [Jech, 1993] axioms : Incomplete.
% English  : 

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : Problem 9 [Jech, 1993]

% Status   : 
% Syntax   : Number of clauses           :   26 (   2 non-Horn)(  14 unit)
%            Number of literals          :   43 (  26 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   13 (  11 constant)
%            Number of variables         :   38 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Embedding algebra axioms 
include('Axioms/LDA001-0.ax').
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [++equal(ts,f(t,s))]).

input_clause(clause_2,axiom,
    [++equal(bts,f(bt,s))]).

input_clause(clause_3,axiom,
    [++equal(ta,f(t,a))]).

input_clause(clause_4,axiom,
    [++equal(bta,f(bt,a))]).

input_clause(clause_5,axiom,
    [++equal(k,critical_point(t))]).

input_clause(clause_6,axiom,
    [++equal(critical_point(bt),k)]).

input_clause(clause_7,axiom,
    [++equal(tsk,f(ts,k))]).

input_clause(clause_8,axiom,
    [++equal(btsk,f(bts,k))]).

input_clause(clause_9,axiom,
    [++less(bta,btsk)]).

%----ta<tsk,  assuming Ta<Tsk and k=crit(t)=crit(T) 
input_clause(prove_equation,theorem,
    [--less(ta,tsk)]).
%--------------------------------------------------------------------------
