%--------------------------------------------------------------------------
% File     : LDA007=EmbdgAlgEqn3-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras (Embedding algebras)
% Problem  : Let g = cr(t). Show that t(tsg) = tt(ts)(tg) 
% Version  : [Jech, 1993] axioms :
%            Incomplete > Reduced & Augmented > Incomplete.
% English  : 

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : Problem 8 [Jech, 1993]

% Status   : 
% Syntax   : Number of clauses           :   13 (   2 non-Horn)(   3 unit)
%            Number of literals          :   27 (  12 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    2 (   0 constant)
%            Number of variables         :   32 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Embedding algebra axioms 
% include('Axioms/LDA001-0.ax').
%--------------------------------------------------------------------------
input_clause(a1,axiom,
    [++equal(f(X,f(Y,Z)),f(f(X,Y),f(X,Z)))]).

input_clause(f_substitution1,axiom,
    [--equal(F,G),
     ++equal(f(F,H),f(G,H))]).

input_clause(f_substitution2,axiom,
    [--equal(I,J),
     ++equal(f(K,I),f(K,J))]).

input_clause(clause_1,axiom,
    [++equal(tt,f(t,t))]).

input_clause(clause_2,axiom,
    [++equal(ts,f(t,s))]).

input_clause(clause_3,axiom,
    [++equal(tt_ts,f(tt,ts))]).

input_clause(clause_4,axiom,
    [++equal(tk,f(t,k))]).

input_clause(clause_5,axiom,
    [++equal(tsk,f(ts,k))]).

%----t(tsk) = tt(ts)(tk), where k=crit(t) 
input_clause(prove_equation,theorem,
    [--equal(f(t,tsk),f(tt_ts,tk))]).
%--------------------------------------------------------------------------
