%--------------------------------------------------------------------------
% File     : LDA007=EmbdgAlgEqn3-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras (Embedding algebras)
% Problem  : Let g = cr(t). Show that t(tsg) = tt(ts)(tg)
% Version  : [Jech, 1993] axioms :
%            Incomplete > Reduced & Augmented > Incomplete.
% English  : 

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   27 (   2 non-Horn)(  15 unit)
%            Number of literals          :   42 (  31 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   14 (  12 constant)
%            Number of variables         :   38 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Embedding algebra axioms 
% include('Axioms/LDA001-0.ax').
%--------------------------------------------------------------------------
input_clause(a1,axiom,
    [++equal(f(X,f(Y,Z)),f(f(X,Y),f(X,Z)))]).

input_clause(a2,axiom,
    [++equal(critical_point(f(U,V)),f(U,critical_point(V)))]).

input_clause(b1,axiom,
    [--less(X,X)]).

% input_clause(b2,axiom,
%     [++less(X,Y),
%      ++less(Y,X),
%      ++equal(X,Y)]).

% input_clause(b3,axiom,
%     [--less(X,Y),
%      --less(Y,Z),
%      ++less(X,Z)]).

input_clause(b4,axiom,
    [--less(X,Y),
     ++less(f(U,X),f(U,Y))]).

input_clause(c1,axiom,
    [++equal(X,f(U,X)),
     ++less(X,f(U,X))]).

input_clause(c2,axiom,
    [--less(X,critical_point(U)),
     ++equal(f(U,X),X)]).

input_clause(c3,axiom,
    [++less(X,critical_point(U)),
     ++less(X,f(U,X))]).

% input_clause(d1,axiom,
%     [--less(X,Y),
%      ++less(X,f(U,Y))]).

input_clause(d2,axiom,
    [--equal(f(U,X),X),
     ++equal(f(f(V,U),X),X)]).

input_clause(critical_point_substitution1,axiom,
    [--equal(D,E),
     ++equal(critical_point(D),critical_point(E))]).

input_clause(f_substitution1,axiom,
    [--equal(F,G),
     ++equal(f(F,H),f(G,H))]).

input_clause(f_substitution2,axiom,
    [--equal(I,J),
     ++equal(f(K,I),f(K,J))]).

input_clause(less_substitution1,axiom,
    [--equal(L,M),
     --less(L,N),
     ++less(M,N)]).

input_clause(less_substitution2,axiom,
    [--equal(O,P),
     --less(Q,O),
     ++less(Q,P)]).

input_clause(clause_1,axiom,
    [++equal(tt,f(t,t))]).

input_clause(clause_2,axiom,
    [++equal(st,f(s,t))]).

input_clause(clause_3,axiom,
    [++equal(ts,f(t,s))]).

input_clause(clause_4,axiom,
    [++equal(tt_ts,f(tt,ts))]).

input_clause(clause_5,axiom,
    [++equal(k,critical_point(t))]).

input_clause(clause_6,axiom,
    [++equal(sk,f(s,k))]).

input_clause(clause_7,axiom,
    [++equal(tk,f(t,k))]).

input_clause(clause_8,axiom,
    [++equal(stk,f(st,k))]).

input_clause(clause_9,axiom,
    [++equal(tsk,f(ts,k))]).

input_clause(clause_10,axiom,
    [++equal(ttk,f(tt,k))]).

%---- t(tsk) = tt(ts)(tk), where k=crit(t) 
input_clause(prove_equation,theorem,
    [--equal(f(t,tsk),f(tt_ts,tk))]).
%--------------------------------------------------------------------------
