%--------------------------------------------------------------------------
% File     : LDA005=EmbdgAlgEqn1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras (Embedding algebras)
% Problem  : Let g=cr(t). Show that tt(tsg) < t(tsg) (for any s)
% Version  : [Jech, 1993] axioms : Incomplete.
% English  : 

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : Problem 5 [Jech, 1993]

% Status   : 
% Syntax   : Number of clauses           :   25 (   2 non-Horn)(  13 unit)
%            Number of literals          :   42 (  26 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :   12 (  10 constant)
%            Number of variables         :   38 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%----Include Embedding algebra axioms 
include('Axioms/LDA001-0.ax').
%--------------------------------------------------------------------------
input_clause(clause_1,axiom,
    [++equal(tt,f(t,t))]).

input_clause(clause_2,axiom,
    [++equal(st,f(s,t))]).

input_clause(clause_3,axiom,
    [++equal(ts,f(t,s))]).

input_clause(clause_4,axiom,
    [++equal(k,critical_point(t))]).

input_clause(clause_5,axiom,
    [++equal(sk,f(s,k))]).

input_clause(clause_6,axiom,
    [++equal(tk,f(t,k))]).

input_clause(clause_7,axiom,
    [++equal(stk,f(st,k))]).

input_clause(clause_8,axiom,
    [++equal(tsk,f(ts,k))]).

%----tt(tsk) < t(tsk), where k=crit(t) 
input_clause(prove_equation,theorem,
    [--less(f(tt,tsk),f(t,tsk))]).
%--------------------------------------------------------------------------
