%--------------------------------------------------------------------------
% File     : LDA003=LeftSegEqn1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras (Left segments)
% Problem  : Show that 3 is a left segment of U = 2*2
% Version  : [Jech, 1993] axioms.
% English  : 

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : Problem 3 [Jech, 1993]

% Status   : 
% Syntax   : Number of clauses           :   14 (   0 non-Horn)(   7 unit)
%            Number of literals          :   25 (  16 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :   26 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----A1: x(yz)=xy(xz) 
input_clause(a1,axiom,
    [++equal(f(X,f(Y,Z)),f(f(X,Y),f(X,Z)))]).

%----x is a left segment of xy 
input_clause(a2,axiom,
    [++left(X,f(X,Y))]).

%----transitive 
input_clause(a3,axiom,
    [--left(X,Y),
     --left(Y,Z),
     ++left(X,Z)]).

input_clause(clause_4,axiom,
    [++equal(2,f(1,1))]).

input_clause(clause_5,axiom,
    [++equal(3,f(2,1))]).

input_clause(clause_6,axiom,
    [++equal(u,f(2,2))]).

input_clause(f_substitution1,axiom,
    [--equal(A,B),
     ++equal(f(A,C),f(B,C))]).

input_clause(f_substitution2,axiom,
    [--equal(D,E),
     ++equal(f(F,D),f(F,E))]).

input_clause(left_substitution1,axiom,
    [--equal(G,H),
     --left(G,I),
     ++left(H,I)]).

input_clause(left_substitution2,axiom,
    [--equal(J,K),
     --left(L,J),
     ++left(L,K)]).

%----3 is a left segment of U 
input_clause(prove_equation,theorem,
    [--left(3,u)]).
%--------------------------------------------------------------------------
