%--------------------------------------------------------------------------
% File     : LDA002=LDAlgEqn2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras
% Problem  : Verify 3*2(U2)(UU(UU)) = U1(U3)(UU(UU))
% Version  : [Jech, 1993] (equality) axioms.
% English  : 

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : Problem 2 [Jech, 1993]

% Status   : 
% Syntax   : Number of clauses           :   17 (   0 non-Horn)(  13 unit)
%            Number of literals          :   22 (  22 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :   12 (  11 constant)
%            Number of variables         :   15 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----A1: x(yz)=xy(xz) 
input_clause(a1,axiom,
    [++equal(f(X,f(Y,Z)),f(f(X,Y),f(X,Z)))]).

input_clause(clause_2,axiom,
    [++equal(2,f(1,1))]).

input_clause(clause_3,axiom,
    [++equal(3,f(2,1))]).

input_clause(clause_4,axiom,
    [++equal(u,f(2,2))]).

input_clause(clause_5,axiom,
    [++equal(u1,f(u,1))]).

input_clause(clause_6,axiom,
    [++equal(u2,f(u,2))]).

input_clause(clause_7,axiom,
    [++equal(u3,f(u,3))]).

input_clause(clause_8,axiom,
    [++equal(uu,f(u,u))]).

input_clause(clause_9,axiom,
    [++equal(a,f(f(3,2),u2))]).

input_clause(clause_10,axiom,
    [++equal(b,f(u1,u3))]).

input_clause(clause_11,axiom,
    [++equal(v,f(uu,uu))]).

input_clause(f_substitution1,axiom,
    [--equal(A,B),
     ++equal(f(A,C),f(B,C))]).

input_clause(f_substitution2,axiom,
    [--equal(D,E),
     ++equal(f(F,D),f(F,E))]).

%----3*2*U2*(UU*UU) = U1*U3*(uU*UU) 
input_clause(prove_equation,theorem,
    [--equal(f(a,v),f(b,v))]).
%--------------------------------------------------------------------------
