%--------------------------------------------------------------------------
% File     : LDA001=LDAlgEqn1-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : LD-Algebras
% Problem  : Verify 3*2*U = UUU, where U = 2*2
% Version  : [Jech, 1993] (equality) axioms.
% English  : 

% Refs     : Jech T. (1993), LD-algebras, AAR Newsletter 22, 9-12.
% Source   : [Jech, 1993]
% Names    : Problem 1 [Jech, 1993]

% Status   : 
% Syntax   : Number of clauses           :   10 (   0 non-Horn)(   6 unit)
%            Number of literals          :   15 (  15 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :   15 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    3

% Comments : 
%--------------------------------------------------------------------------
%----Include Reflexivity, symmetry and transitivity, of equality 
include('Axioms/EQU001-0.ax').
%--------------------------------------------------------------------------
%----A1: x(yz)=xy(xz) 
input_clause(a1,axiom,
    [++equal(f(X,f(Y,Z)),f(f(X,Y),f(X,Z)))]).

input_clause(clause_2,axiom,
    [++equal(2,f(1,1))]).

input_clause(clause_3,axiom,
    [++equal(3,f(2,1))]).

input_clause(clause_4,axiom,
    [++equal(u,f(2,2))]).

input_clause(f_substitution1,axiom,
    [--equal(A,B),
     ++equal(f(A,C),f(B,C))]).

input_clause(f_substitution2,axiom,
    [--equal(D,E),
     ++equal(f(F,D),f(F,E))]).

%----3*2*U = U*U*U 
input_clause(prove_equation,theorem,
    [--equal(f(f(3,2),u),f(f(u,u),u))]).
%--------------------------------------------------------------------------
