%--------------------------------------------------------------------------
% File     : LCL168=XEHNotAx-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Equivalential)
% Problem  : XEH is not a single axiom for the R-calculus
% Version  : 
% English  : To show that XEH is not a single axiom, attempt to derive 
%            from it any one of YQM, WO, XGJ or QYF, which are known 
%            single axioms.

% Refs     : Wos L., Winker S., McCune W.W., Overbeek R., Lusk E. and 
%            Stevens R. (1990), Automated Reasoning Contributes 
%            to Mathemetics and Logic, In Stickel M.E. (Ed), Proceedings 
%            of the 10th International Conference on Automated Deduction 
%            (Kaiserslautern, Germany, 1990), (Lecture Notes in Artificial 
%            Intelligence, 449), Springer-Verlag, NY, 485-499.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
% Source   : [Wos, et al., 1990]
% Names    : RC-2 [Wos, et al., 1990]

% Status   : satisfiable
% Syntax   : Number of clauses           :    6 (   0 non-Horn)(   5 unit)
%            Number of literals          :    8 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    5 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : This is not how the problem is attacked in [Wos, et al., 
%            1990].
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(xeh,axiom,
    [++is_a_theorem(equivalent(X,equivalent(equivalent(Y,equivalent(
equivalent(Y,Z),X)),Z)))]).

%----Axiom from Meredith 
input_clause(try_prove_qyf,theorem,
    [--is_a_theorem(equivalent(equivalent(equivalent(a,b),
equivalent(a,c)),equivalent(c,b)))]).

%----Axiom from Meredith 
input_clause(try_prove_yqm,theorem,
    [--is_a_theorem(equivalent(equivalent(a,b),equivalent(
equivalent(c,b),equivalent(c,a))))]).

%----Axiom from Meredith 
input_clause(try_prove_wo,theorem,
    [--is_a_theorem(equivalent(equivalent(a,equivalent(b,c)),
equivalent(c,equivalent(b,a))))]).

%----Axiom from Winker 
input_clause(try_prove_xgj,theorem,
    [--is_a_theorem(equivalent(a,equivalent(equivalent(b,
equivalent(c,a)),equivalent(b,c))))]).
%--------------------------------------------------------------------------
