%--------------------------------------------------------------------------
% File     : LCL166=XHN_UM-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Equivalential)
% Problem  : UM depends on XHN
% Version  : 
% English  : Show that the single Meredith axiom UM can be derived from 
%            the single Winker axiom XHN.

% Refs     : Wos L., Winker S., McCune W.W., Overbeek R., Lusk E. and 
%            Stevens R. (1990), Automated Reasoning Contributes 
%            to Mathemetics and Logic, In Stickel M.E. (Ed), Proceedings 
%            of the 10th International Conference on Automated Deduction 
%            (Kaiserslautern, Germany, 1990), (Lecture Notes in Artificial 
%            Intelligence, 449), Springer-Verlag, NY, 485-499.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
% Source   : [Wos, et al., 1990]
% Names    : EC-1 [Wos, et al., 1990]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    5 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

%----Axiom by Winker 
input_clause(xhn,axiom,
    [++is_a_theorem(equivalent(X,equivalent(equivalent(Y,Z),
equivalent(equivalent(Z,X),Y))))]).

%----Axiom by Meredith 
input_clause(prove_um,theorem,
    [--is_a_theorem(equivalent(equivalent(equivalent(a,b),c),
equivalent(b,equivalent(c,a))))]).
%--------------------------------------------------------------------------
