%--------------------------------------------------------------------------
% File     : LCL165=WjAlg1Eqn11-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Wajsberg Algebra)
% Problem  : A theorem in Wajsberg algebras
% Version  : [Bonacina, 1991] (equality) axioms.
% English  : 

% Refs     : Font J.M., Rodriguez A.J., Torrens A. (1984), Wajsberg 
%            Algebras, Stochastica 8(1), 5-31.
%          : Anantharaman S., Bonacina M.P. (1990), An Application of the 
%            Theorem Prover SBR3 to Many-Valued Logic, Okada M., 
%            Kaplan S. (Ed.), Proceedings of the 2nd International 
%            Workshop on Conditional and Typed Rewriting Systems 
%            (Montreal, Canada, 1990), (Lecture Notes in Computer Science 
%            516), 156-161.
%          : Bonacina M.P. (1991), Problems in Lukasiewicz Logic, AAR 
%            Newsletter 18, 5-12.
% Source   : [Bonacina, 1991]
% Names    : Third problem [Bonacina, 1991]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(  12 unit)
%            Number of literals          :   31 (  31 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   2 constant)
%            Number of variables         :   48 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Wajsberg algebra axioms 
include('Axioms/LCL001-0.ax').
%----Include Wajsberg algebra and and or definitions 
include('Axioms/LCL001-2.ax').
%--------------------------------------------------------------------------
input_clause(prove_wajsberg_theorem,theorem,
    [--equal(not(or(and(x,or(x,x)),and(x,x))),and(not(x),or(or(not(x),
not(x)),and(not(x),not(x)))))]).
%--------------------------------------------------------------------------
