%--------------------------------------------------------------------------
% File     : LCL162=WjAlg1Ax2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Wajsberg Algebra)
% Problem  : The 2nd Wajsberg algebra axiom, from the alternative axioms
% Version  : [Bonacina, 1991] (equality) axioms.
% English  : 

% Refs     : Font J.M., Rodriguez A.J., Torrens A. (1984), Wajsberg 
%            Algebras, Stochastica 8(1), 5-31.
%          : Anantharaman S., Bonacina M.P. (1990), An Application of the 
%            Theorem Prover SBR3 to Many-Valued Logic, Okada M., 
%            Kaplan S. (Ed.), Proceedings of the 2nd International 
%            Workshop on Conditional and Typed Rewriting Systems 
%            (Montreal, Canada, 1990), (Lecture Notes in Computer Science 
%            516), 156-161.
%          : Bonacina M.P. (1991), Problems in Lukasiewicz Logic, AAR 
%            Newsletter 18, 5-12.
% Source   : [Bonacina, 1991]
% Names    : W axiom 2 [Bonacina, 1991]

% Status   : 
% Syntax   : Number of clauses           :   24 (   0 non-Horn)(  15 unit)
%            Number of literals          :   34 (  34 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   5 constant)
%            Number of variables         :   45 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Alternative Wajsberg algebra axioms 
include('Axioms/LCL002-0.ax').
%--------------------------------------------------------------------------
%----Include some Alternative Wajsberg algebra definitions 
% include('Axioms/LCL002-1.ax').
input_clause(and_star_substitution1,axiom,
    [--equal(G,H),
     ++equal(and_star(G,I),and_star(H,I))]).

input_clause(and_star_substitution2,axiom,
    [--equal(J,K),
     ++equal(and_star(L,J),and_star(L,K))]).

input_clause(xor_substitution1,axiom,
    [--equal(S,T),
     ++equal(xor(S,U),xor(T,U))]).

input_clause(xor_substitution2,axiom,
    [--equal(V,W),
     ++equal(xor(X,V),xor(X,W))]).

%----Definition that and_star is AC and xor is C 
input_clause(xor_commutativity,axiom,
    [++equal(xor(X,Y),xor(Y,X))]).

input_clause(and_star_associativity,axiom,
    [++equal(and_star(and_star(X,Y),Z),and_star(X,and_star(Y,Z)))]).

input_clause(and_star_commutativity,axiom,
    [++equal(and_star(X,Y),and_star(Y,X))]).

%----Definition of false in terms of true 
input_clause(false_definition,axiom,
    [++equal(not(true),false)]).

%----Include the definition of implies in terms of xor and and_star 
input_clause(implies_definition,axiom,
    [++equal(implies(X,Y),xor(true,and_star(X,xor(true,Y))))]).

input_clause(prove_wajsberg_axiom,theorem,
    [--equal(implies(implies(x,y),implies(implies(y,z),
implies(x,z))),true)]).
%--------------------------------------------------------------------------
