%--------------------------------------------------------------------------
% File     : LCL155=WjAlg2Ax3-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Wajsberg Algebra)
% Problem  : The 3rd alternative Wajsberg algebra axiom
% Version  : [Bonacina, 1991] (equality) axioms.
% English  : 

% Refs     : Font J.M., Rodriguez A.J., Torrens A. (1984), Wajsberg 
%            Algebras, Stochastica 8(1), 5-31.
%          : Anantharaman S., Bonacina M.P. (1990), An Application of the 
%            Theorem Prover SBR3 to Many-Valued Logic, Okada M., 
%            Kaplan S. (Ed.), Proceedings of the 2nd International 
%            Workshop on Conditional and Typed Rewriting Systems 
%            (Montreal, Canada, 1990), (Lecture Notes in Computer Science 
%            516), 156-161.
%          : Bonacina M.P. (1991), Problems in Lukasiewicz Logic, AAR 
%            Newsletter 18, 5-12.
% Source   : [Bonacina, 1991]
% Names    : W' axiom 3 [Bonacina, 1991]

% Status   : 
% Syntax   : Number of clauses           :   31 (   0 non-Horn)(  18 unit)
%            Number of literals          :   45 (  45 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    9 (   3 constant)
%            Number of variables         :   71 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Wajsberg algebra axioms 
include('Axioms/LCL001-0.ax').
%----Include Wajsberg algebra and and or definitions 
include('Axioms/LCL001-2.ax').
%----Include Alternative Wajsberg algebra definitions 
include('Axioms/LCL002-1.ax').
%--------------------------------------------------------------------------
input_clause(prove_alternative_wajsberg_axiom,theorem,
    [--equal(xor(x,x),false)]).
%--------------------------------------------------------------------------
