%--------------------------------------------------------------------------
% File     : LCL150=WjLattEqn10-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Wajsberg Algebra)
% Problem  : A theorem in the lattice structure of Wajsberg algebras
% Version  : [Bonacina, 1991] (equality) axioms.
% English  : 

% Refs     : Font J.M., Rodriguez A.J., Torrens A. (1984), Wajsberg 
%            Algebras, Stochastica 8(1), 5-31.
%          : Bonacina M.P. (1991), Problems in Lukasiewicz Logic, AAR 
%            Newsletter 18, 5-12.
% Source   : [Bonacina, 1991]
% Names    : Lattice structure theorem 10 [Bonacina, 1991]

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(   8 unit)
%            Number of literals          :   37 (  31 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    8 (   4 constant)
%            Number of variables         :   48 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Wajsberg algebra axioms 
include('Axioms/LCL001-0.ax').
%----Include Wajsberg algebra lattice structure axioms 
include('Axioms/LCL001-1.ax').
%--------------------------------------------------------------------------
input_clause(prove_wajsberg_theorem,theorem,
    [--equal(implies(big_hat(x,y),z),big_V(implies(x,z),implies(y,z)))]).
%--------------------------------------------------------------------------
