%--------------------------------------------------------------------------
% File     : LCL136=WjAlg1Eqn5-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Wajsberg Algebra)
% Problem  : A lemma in Wajsberg algebras
% Version  : [Bonacina, 1991] (equality) axioms.
% English  : An axiomatisation of the many valued sentential calculus 
%            is {MV-1,MV-2,MV-3,MV-5} by Meredith. Wajsberg provided 
%            a different axiomatisation. Show that a version of MV-2 
%            depends on the Wajsberg system.

% Refs     : Font J.M., Rodriguez A.J., Torrens A. (1984), Wajsberg 
%            Algebras, Stochastica 8(1), 5-31.
%          : Bonacina M.P. (1991), Problems in Lukasiewicz Logic, AAR 
%            Newsletter 18, 5-12.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
% Source   : [Bonacina, 1991]
% Names    : Lemma 5 [Bonacina, 1991]

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   7 unit)
%            Number of literals          :   18 (  18 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    6 (   4 constant)
%            Number of variables         :   22 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Wajsberg algebra axioms 
include('Axioms/LCL001-0.ax').
%--------------------------------------------------------------------------
input_clause(lemma_antecedent,theorem,
    [++equal(implies(x,y),implies(y,z))]).

input_clause(prove_wajsberg_lemma,theorem,
    [--equal(implies(x,z),true)]).
%--------------------------------------------------------------------------
