%--------------------------------------------------------------------------
% File     : LCL133=WjAlg1Eqn2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Wajsberg Algebra)
% Problem  : A lemma in Wajsberg algebras
% Version  : [Bonacina, 1991] (equality) axioms.
% English  : 

% Refs     : Font J.M., Rodriguez A.J., Torrens A. (1984), Wajsberg 
%            Algebras, Stochastica 8(1), 5-31.
%          : Bonacina M.P. (1991), Problems in Lukasiewicz Logic, AAR 
%            Newsletter 18, 5-12.
% Source   : [Bonacina, 1991]
% Names    : Lemma 2 [Bonacina, 1991]

% Status   : 
% Syntax   : Number of clauses           :   12 (   0 non-Horn)(   7 unit)
%            Number of literals          :   18 (  18 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   24 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Wajsberg algebra axioms 
include('Axioms/LCL001-0.ax').
%--------------------------------------------------------------------------
input_clause(lemma_antecedent,theorem,
    [++equal(implies(X,Y),implies(Y,X))]).

input_clause(prove_wajsberg_lemma,theorem,
    [--equal(x,y)]).
%--------------------------------------------------------------------------
