%--------------------------------------------------------------------------
% File     : LCL131=LG2_S6-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Right group)
% Problem  : LG-2 depends on S-6
% Version  : 
% English  : Kalman's axiomatisation of the right group calculus 
%            is {LG-1,LG-2,LG-3,LG-4,LG-5}. McCune has shown that LG-2 
%            is a single axiom. Other axiomatisations by McCune are 
%            {Q-2,Q-3}, {Q-3,Q-4}, S-2, S-3, S-4, P-4, S-6. Show that LG-2 
%            depends on S-6.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Automated Discovery of New 
%            Axiomatisations of the Left Group and Right Group Calculi, 
%            In Journal of Automated Reasoning 9(1), Kluwer Academic 
%            Publishers, Dordrecht, The Netherlands, 1-24.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : RG-112 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   4 constant)
%            Number of variables         :    6 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    6

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(s_6,axiom,
    [++is_a_theorem(equivalent(equivalent(X,equivalent(equivalent(
equivalent(Y,Z),equivalent(U,Z)),equivalent(Y,U))),X))]).

input_clause(prove_lg_2,theorem,
    [--is_a_theorem(equivalent(a,equivalent(a,equivalent(
equivalent(b,c),equivalent(equivalent(b,e),equivalent(c,e))))))]).
%--------------------------------------------------------------------------
