%--------------------------------------------------------------------------
% File     : LCL126=Mc2_LG2-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Right group)
% Problem  : Q-2 depends on the 2nd McCune system
% Version  : 
% English  : Kalman's axiomatisation of the right group calculus 
%            is {LG-1,LG-2,LG-3,LG-4,LG-5}. McCune has shown that LG-2 
%            is a single axiom. Other axiomatisations by McCune are 
%            {Q-2,Q-3}, {Q-3,Q-4}, S-2, S-3, S-4, P-4, S-6. Show that Q-2 
%            depends on the second McCune system.

% Refs     : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Automated Discovery of New 
%            Axiomatisations of the Left Group and Right Group Calculi, 
%            In Journal of Automated Reasoning 9(1), Kluwer Academic 
%            Publishers, Dordrecht, The Netherlands, 1-24.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : RG-107 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    4 (   0 non-Horn)(   3 unit)
%            Number of literals          :    6 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    8 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(q_3,axiom,
    [++is_a_theorem(equivalent(X,equivalent(equivalent(X,
equivalent(Y,Z)),equivalent(Z,Y))))]).

input_clause(q_4,axiom,
    [++is_a_theorem(equivalent(equivalent(X,Y),equivalent(
equivalent(X,Z),equivalent(Y,Z))))]).

input_clause(prove_q_2,theorem,
    [--is_a_theorem(equivalent(equivalent(equivalent(a,b),
equivalent(c,b)),equivalent(a,c)))]).
%--------------------------------------------------------------------------
