%--------------------------------------------------------------------------
% File     : LCL119=XGJ_WO-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (R)
% Problem  : WO depends on XGJ
% Version  : 
% English  : Single axioms for the R calculus are QYF, YQM, WO, all 
%            by Meredith and XGJ by Winker. Show that WO depends on XGJ.

% Refs     : Wos L., Winker S., McCune W.W., Overbeek R., Lusk E. and 
%            Stevens R. (1990), Automated Reasoning Contributes 
%            to Mathemetics and Logic, In Stickel M.E. (Ed), Proceedings 
%            of the 10th International Conference on Automated Deduction 
%            (Kaiserslautern, Germany, 1990), (Lecture Notes in Artificial 
%            Intelligence, 449), Springer-Verlag, NY, 485-499.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
% Source   : [McCune, 1992]
% Names    : RC-1 [Wos, et al., 1990]
%          : R-87 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :    3 (   0 non-Horn)(   2 unit)
%            Number of literals          :    5 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    4 (   3 constant)
%            Number of variables         :    5 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    5

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(equivalent(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

%----Axiom from Winker 
input_clause(xgj,axiom,
    [++is_a_theorem(equivalent(X,equivalent(equivalent(Y,
equivalent(Z,X)),equivalent(Y,Z))))]).

%----Axiom from Meredith 
input_clause(prove_wo,theorem,
    [--is_a_theorem(equivalent(equivalent(a,equivalent(b,c)),
equivalent(c,equivalent(b,a))))]).
%--------------------------------------------------------------------------
