%--------------------------------------------------------------------------
% File     : LCL114=CAM_MV36-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Many valued sentential)
% Problem  : MV-36 depends on the Meredith system
% Version  : Theorem formulation : Wajsberg algebra formulation
% English  : An axiomatisation of the many valued sentential calculus 
%            is {MV-1,MV-2,MV-3,MV-5} by Meredith. Wajsberg presented 
%            an equality axiomatisation. Show that MV-36 depends on the 
%            Wajsberg axiomatisation.

% Refs     : Font J.M., Rodriguez A.J., Torrens A. (1984), Wajsberg 
%            Algebras, Stochastica 8(1), 5-31.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
% Source   : [Lusk & Wos, 1992]
% Names    : MV3 [Lusk & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   6 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   22 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Wajsberg algebra axioms 
include('Axioms/LCL001-0.ax').
%--------------------------------------------------------------------------
input_clause(prove_mv_36,theorem,
    [--equal(implies(implies(x,y),implies(not(y),not(x))),true)]).
%--------------------------------------------------------------------------
