%--------------------------------------------------------------------------
% File     : LCL111=CAM_MV25-1 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Many valued sentential)
% Problem  : MV-25 depends on the Merideth system
% Version  : 
% English  : An axiomatisation of the many valued sentential calculus 
%            is {MV-1,MV-2,MV-3,MV-5} by Meredith. Show that MV-25 depends 
%            on the Meredith system.

% Refs     : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : McCune W.W. (1992), Email to Geoff Sutcliffe.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [McCune, 1992]
% Names    : Overbeek Competition 6 [Overbeek, 1990]
%          : MV-57 [McCune & Wos, 1992]
%          : mv.in part 2 [OTTER]
%          : ovb6 [SETHEO]

% Status   : 
% Syntax   : Number of clauses           :    6 (   0 non-Horn)(   5 unit)
%            Number of literals          :    8 (   0 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   11 (   1 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
input_clause(condensed_detachment,axiom,
    [--is_a_theorem(implies(X,Y)),
     --is_a_theorem(X),
     ++is_a_theorem(Y)]).

input_clause(mv_1,axiom,
    [++is_a_theorem(implies(X,implies(Y,X)))]).

input_clause(mv_2,axiom,
    [++is_a_theorem(implies(implies(X,Y),implies(implies(Y,Z),
implies(X,Z))))]).

input_clause(mv_3,axiom,
    [++is_a_theorem(implies(implies(implies(X,Y),Y),
implies(implies(Y,X),X)))]).

input_clause(mv_5,axiom,
    [++is_a_theorem(implies(implies(not(X),not(Y)),implies(Y,X)))]).

input_clause(prove_mv_25,theorem,
    [--is_a_theorem(implies(implies(a,b),implies(implies(c,a),
implies(c,b))))]).
%--------------------------------------------------------------------------
