%--------------------------------------------------------------------------
% File     : LCL109=CAM_MV4-5 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Wajsberg Algebra)
% Problem  : A theorem in the lattice structure of Wajsberg algebras
% Version  : [Bonacina, 1991] (equality) axioms : Augmented.
%            Theorem formulation : Wajsberg algebras lattice structure.
% English  : 

% Refs     : Font J.M., Rodriguez A.J., Torrens A. (1984), Wajsberg 
%            Algebras, Stochastica 8(1), 5-31.
%          : Bonacina M.P. (1991), Problems in Lukasiewicz Logic, AAR 
%            Newsletter 18, 5-12.
% Source   : [Bonacina, 1991]
% Names    : Lattice structure theorem 8 [Bonacina, 1991]

% Status   : 
% Syntax   : Number of clauses           :   29 (   0 non-Horn)(  12 unit)
%            Number of literals          :   49 (  35 equality)
%            Number of predicate symbols :    2 (   0 propositional)
%            Number of function symbols  :    7 (   3 constant)
%            Number of variables         :   70 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Wajsberg algebra axioms 
include('Axioms/LCL001-0.ax').
%----Include Wajsberg algebra lattice structure axioms 
include('Axioms/LCL001-1.ax').
%--------------------------------------------------------------------------
%----Lemmas in Wajsberg algebra lattice structures.
input_clause(lemma_1,axiom,
    [--ordered(X,Y),
     ++ordered(implies(X,Z),implies(Y,Z))]).

input_clause(lemma_2,axiom,
    [--ordered(X,Y),
     ++ordered(implies(Z,X),implies(Z,Y))]).

input_clause(lemma_3_1,axiom,
    [--ordered(X,implies(Y,Z)),
     ++ordered(Y,implies(X,Z))]).

input_clause(lemma_3_2,axiom,
    [--ordered(Y,implies(X,Z)),
     ++ordered(X,implies(Y,Z))]).

input_clause(lemma_4,axiom,
    [++equal(not(big_V(X,Y)),big_hat(not(X),not(Y)))]).

input_clause(lemma_5,axiom,
    [++equal(not(big_hat(X,Y)),big_V(not(X),not(Y)))]).

input_clause(lemma_6,axiom,
    [++equal(implies(big_V(X,Y),Z),big_hat(implies(X,Z),implies(Y,Z)))]).

input_clause(lemma_7,axiom,
    [++equal(implies(X,big_hat(Y,Z)),big_hat(implies(X,Y),implies(X,Z)))]).

input_clause(prove_mv_4,theorem,
    [--equal(big_V(implies(x,y),implies(y,x)),true)]).
%--------------------------------------------------------------------------
