%--------------------------------------------------------------------------
% File     : LCL109=CAM_MV4-3 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Many valued sentential)
% Problem  : MV-4 depends on the Merideth system
% Version  : [Bonacina, 1991] (equality) axioms : Augmented.
%            Theorem formulation : Wajsberg algebra formulation.
% English  : An axiomatisation of the many valued sentential calculus 
%            is {MV-1,MV-2,MV-3,MV-5} by Meredith. Show that MV-4 depends 
%            on the Meredith system.

% Refs     : Bonacina M.P. (1991), Problems in Lukasiewicz Logic, AAR 
%            Newsletter 18, 5-12.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
% Source   : [Bonacina, 1991]
% Names    : 

% Status   : 
% Syntax   : Number of clauses           :   21 (   0 non-Horn)(  14 unit)
%            Number of literals          :   29 (  29 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   41 (   2 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Wajsberg algebra axioms 
include('Axioms/LCL001-0.ax').
%--------------------------------------------------------------------------
%----Lemmas that are true in any Wajsberg algebra 
input_clause(lemma_1,axiom,
    [++equal(implies(X,X),true)]).

input_clause(lemma_2,axiom,
    [--equal(implies(X,Y),implies(Y,X)),
     ++equal(X,Y)]).

input_clause(lemma_3,axiom,
    [++equal(implies(X,true),true)]).

input_clause(lemma_4,axiom,
    [++equal(implies(X,implies(Y,X)),true)]).

input_clause(lemma_5,axiom,
    [--equal(implies(X,Y),implies(Y,Z)),
     ++equal(implies(X,Z),true)]).

input_clause(lemma_6,axiom,
    [++equal(implies(implies(X,Y),implies(implies(Z,X),implies(Z,Y))),
true)]).

input_clause(lemma_7,axiom,
    [++equal(implies(X,implies(Y,Z)),implies(Y,implies(X,Z)))]).

input_clause(lemma_8,axiom,
    [++equal(implies(X,not(true)),not(X))]).

input_clause(lemma_9,axiom,
    [++equal(not(not(X)),X)]).

input_clause(lemma_10,axiom,
    [++equal(implies(not(X),not(Y)),implies(Y,X))]).

input_clause(prove_wajsberg_mv_4,theorem,
    [--equal(implies(implies(implies(a,b),implies(b,a)),
implies(b,a)),true)]).
%--------------------------------------------------------------------------
