%--------------------------------------------------------------------------
% File     : LCL109=CAM_MV4-2 : TPTP v1.1.1. Bugfixed v1.0.0.
% Domain   : Logic Calculi (Many valued sentential)
% Problem  : MV-4 depends on the Merideth system
% Version  : Theorem formulation : Wajsberg algebra formulation.
% English  : An axiomatisation of the many valued sentential calculus 
%            is {MV-1,MV-2,MV-3,MV-5} by Meredith. Wajsberg provided 
%            a different axiomatisation. Show that MV-4 depends on the 
%            Wajsberg system.

% Refs     : Overbeek R. (1990), ATP competition announced at CADE-10.
%          : McCune W.W., and Wos L. (1992), Experiments in Automated 
%            Deduction with Condensed Detachment, In Kapur D. (Ed), 
%            Proceedings of the 11th International Conference on Automated 
%            Deduction, (Saratoga Springs, NY, 1992), (Lecture Notes 
%            in Artificial Intelligence, 607), Springer-Verlag, NY, 
%            209-223.
%          : Lusk E., McCune W.W. (1992), Experiments with ROO, a Parallel 
%            Automated Deduction System, In Fronhofer B., 
%            Wrightson G. (Eds), Proceedings of the International Workshop 
%            on Parallelization in Inference Systems, (Dagstahl Castle, 
%            Germany, 1990), (Lecture Notes in Artificial Intelligence, 
%            590), Springer-Verlag, NY, 139-162.
%          : Lusk E., and Wos L. (1992), Benchmark Problems in Which 
%            Equality Plays the Major Role, In Kapur D. (Ed.), Proceedings 
%            of the 11th International Conference on Automated Deduction 
%            (Saratoga Springs, NY, 1992), (Lecture Notes in Artificial 
%            Intelligence 607), Springer-Verlag, New York, NY, 781-785.
%          : Overbeek R. (1993), The CADE-11 Competitions: A Personal 
%            View, Journal of Automated Reasoning 11(3), 315-316.
%          : Lusk E.L., McCune W.W. (1993), Uniform Strategies: The 
%            CADE-11 Theorem Proving Contest, Journal of Automated 
%            Reasoning 11(3), 317-331.
%          : Zhang H. (1993), Automated Proofs of Equality Problems 
%            in Overbeek's Competition, Journal of Automated Reasoning 
%            11(3), 333-351.
% Source   : [Overbeek, 1990]
% Names    : Overbeek Competition Eq-5 [Overbeek, 1990]
%          : Luka-5 [Lusk & McCune, 1992]
%          : MV4 [Lusk & Wos, 1992]
%          : Problem 55 [McCune & Wos, 1992]

% Status   : 
% Syntax   : Number of clauses           :   11 (   0 non-Horn)(   6 unit)
%            Number of literals          :   17 (  17 equality)
%            Number of predicate symbols :    1 (   0 propositional)
%            Number of function symbols  :    5 (   3 constant)
%            Number of variables         :   22 (   0 singleton)
%            Maximal clause size         :    3
%            Maximal term depth          :    4

% Comments : 
%--------------------------------------------------------------------------
%----Include axioms of equality 
include('Axioms/EQU001-0.ax').
%----Include Wajsberg algebra axioms 
include('Axioms/LCL001-0.ax').
%--------------------------------------------------------------------------
input_clause(prove_wajsberg_mv_4,theorem,
    [--equal(implies(implies(implies(a,b),implies(b,a)),
implies(b,a)),true)]).
%--------------------------------------------------------------------------
